/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public final class TableCellUtilities {
    private static final DefaultTableCellRenderer dummyRenderer = new DefaultTableCellRenderer();

    private TableCellUtilities() {
    }

    public static void setToRowBackground(Component c, JTable table, int row) {
        dummyRenderer.getTableCellRendererComponent(table, null, false, false, row, 0);
        Color bg = dummyRenderer.getBackground();
        c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
    }

    public static final class AlignRenderer
    extends DefaultTableCellRenderer {
        private int align = 2;
        private final boolean showTooltips;

        public AlignRenderer(int anInt) {
            this(anInt, false);
        }

        public AlignRenderer(int anInt, boolean tooltips) {
            this.align = anInt;
            this.showTooltips = tooltips;
            this.setHorizontalAlignment(this.align);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setEnabled(table == null || table.isEnabled());
            this.setHorizontalAlignment(this.align);
            if (this.showTooltips) {
                this.setToolTipText(String.valueOf(value));
            }
            return this;
        }
    }

    public static class SpinnerRenderer
    extends DefaultTableCellRenderer {
        private final JSpinner spinner;

        public SpinnerRenderer() {
            this(new JSpinner());
        }

        public SpinnerRenderer(JSpinner spinner) {
            this.spinner = spinner;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            this.spinner.setValue(value);
            this.spinner.setEnabled(table.isCellEditable(row, column));
            return this.spinner;
        }
    }

    public static class ToggleButtonRenderer
    extends JComponent
    implements TableCellRenderer {
        private JToggleButton button;
        private DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();

        public ToggleButtonRenderer(JToggleButton button) {
            this.button = button;
            button.setHorizontalAlignment(0);
            button.setBorderPainted(true);
            this.setLayout(new GridLayout(1, 1));
            this.add(button);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                return this.renderer;
            }
            this.setBackground(this.renderer.getBackground());
            this.button.setSelected((Boolean)value);
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public static class SpinnerEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        protected final JSpinner spinner;

        public SpinnerEditor() {
            this(new JSpinner());
        }

        public SpinnerEditor(SpinnerModel model) {
            this(new JSpinner(model));
        }

        public SpinnerEditor(JSpinner spinner) {
            this.spinner = spinner;
            spinner.addChangeListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.spinner.getValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.spinner.setValue(value);
            return this.spinner;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.stopCellEditing();
        }

        @Override
        public boolean stopCellEditing() {
            try {
                this.spinner.commitEdit();
            }
            catch (ParseException ex) {
                return false;
            }
            return super.stopCellEditing();
        }
    }

    public static class RadioButtonEditor
    extends AbstractCellEditor
    implements ActionListener,
    TableCellEditor {
        private JRadioButton button = new JRadioButton();

        public RadioButtonEditor() {
            this.button.setHorizontalAlignment(0);
            this.button.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.isSelected();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            boolean selected = false;
            if (value instanceof Boolean) {
                selected = (Boolean)value;
            } else if (value instanceof String) {
                selected = value.equals("true");
            }
            this.button.setSelected(selected);
            return this.button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.stopCellEditing();
        }
    }
}

