/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.util.treetable;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeNode;
import pcgen.gui2.util.treetable.AbstractTreeTableModel;
import pcgen.gui2.util.treetable.DefaultTreeTableNode;
import pcgen.gui2.util.treetable.TreeTableModel;
import pcgen.gui2.util.treetable.TreeTableNode;

public class DefaultTreeTableModel
extends AbstractTreeTableModel {
    private List<Class<?>> columnClasses;
    private List<String> columnNames;
    private int columnCount;

    protected DefaultTreeTableModel() {
    }

    protected DefaultTreeTableModel(TreeTableNode root) {
        super(root);
    }

    public DefaultTreeTableModel(TableModel tableModel) {
        super(null);
        int x;
        TreeTableNode rootNode = this.createDefaultTreeTableNode();
        this.columnCount = tableModel.getColumnCount();
        for (x = 0; x < tableModel.getRowCount(); ++x) {
            TreeTableNode child = this.createDefaultTreeTableNode();
            rootNode.insert(child, x);
            for (int y = 0; y < this.columnCount; ++y) {
                child.setValueAt(tableModel.getValueAt(x, y), y);
            }
        }
        this.columnClasses = new ArrayList(this.columnCount);
        this.columnNames = new ArrayList<String>(this.columnCount);
        for (x = 0; x < this.columnCount; ++x) {
            this.columnClasses.add(tableModel.getColumnClass(x));
            this.columnNames.add(tableModel.getColumnName(x));
        }
        this.setRoot(rootNode);
    }

    public DefaultTreeTableModel(TreeTableModel treeTableModel) {
        super(null);
        TreeTableNode rootNode = this.createDefaultTreeTableNode((TreeNode)treeTableModel.getRoot());
        this.columnCount = treeTableModel.getColumnCount();
        this.columnClasses = new ArrayList(this.columnCount);
        this.columnNames = new ArrayList<String>(this.columnCount);
        for (int x = 0; x < this.columnCount; ++x) {
            this.columnClasses.add(treeTableModel.getColumnClass(x));
            this.columnNames.add(treeTableModel.getColumnName(x));
        }
        this.setRoot(rootNode);
    }

    protected TreeTableNode createDefaultTreeTableNode() {
        return new DefaultTreeTableNode();
    }

    protected TreeTableNode createDefaultTreeTableNode(TreeNode node) {
        return new DefaultTreeTableNode(node);
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return TreeTableNode.class;
            }
        }
        return this.columnClasses.get(column);
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames.get(column);
    }
}

