/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.util.Arrays;
import java.util.List;
import pcgen.cdom.content.TabInfo;
import pcgen.persistence.lst.SimpleLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class TabLoader
extends SimpleLoader<TabInfo> {
    private List<String> deprecatedTabNames = Arrays.asList("ABILITIES", "CAMPAIGNS", "RACE", "GEAR", "RESOURCES", "NATURALWEAPONS", "SOURCEINFO");

    public TabLoader() {
        super(TabInfo.class);
    }

    @Override
    protected String processFirstToken(LoadContext context, String token) {
        if (!Tab.exists(token)) {
            if (this.deprecatedTabNames.contains(token.toUpperCase())) {
                Logging.deprecationPrint("TAB:" + token + " has been deprecated and is now ignored.", context);
            } else {
                Logging.errorPrint("TAB:" + token + " is not valid.", context);
            }
            return null;
        }
        return super.processFirstToken(context, token);
    }
}

