/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.ParseResult;

public abstract class AbstractYesNoToken<T extends CDOMObject>
extends AbstractNonEmptyToken<T> {
    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, T obj, String value) {
        Boolean set;
        char firstChar = value.charAt(0);
        if (firstChar == 'y' || firstChar == 'Y') {
            if (value.length() > 1 && !value.equalsIgnoreCase("YES")) {
                return new ParseResult.Fail("You should use 'YES' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.TRUE;
        } else {
            if (firstChar != 'N' && firstChar != 'n') {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            if (value.length() > 1 && !value.equalsIgnoreCase("NO")) {
                return new ParseResult.Fail("You should use 'YES' or 'NO' as the " + this.getTokenName() + ": " + value, context);
            }
            set = Boolean.FALSE;
        }
        context.getObjectContext().put((CDOMObject)obj, this.getObjectKey(), set);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, T obj) {
        Boolean b = context.getObjectContext().getObject((CDOMObject)obj, this.getObjectKey());
        if (b == null) {
            return null;
        }
        return new String[]{b != false ? "YES" : "NO"};
    }

    protected abstract ObjectKey<Boolean> getObjectKey();
}

