/*
 * Decompiled with CFR 0.152.
 */
package pcgen.rules.persistence.token;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class ComplexParseResult
implements ParseResult {
    private final List<ParseResult.QueuedMessage> queuedMessages = new LinkedList<ParseResult.QueuedMessage>();

    public ComplexParseResult() {
    }

    public ComplexParseResult(String error) {
        this.addErrorMessage(error);
    }

    public ComplexParseResult(ComplexParseResult toCopy) {
        this.addMessages(toCopy);
    }

    public void addErrorMessage(String msg) {
        this.addParseMessage(Logging.LST_ERROR, msg);
    }

    public void addWarningMessage(String msg) {
        this.addParseMessage(Logging.LST_WARNING, msg);
    }

    public void addInfoMessage(String msg) {
        this.addParseMessage(Logging.LST_INFO, msg);
    }

    protected void addParseMessage(Level lvl, String msg) {
        this.queuedMessages.add(new ParseResult.QueuedMessage(lvl, msg));
    }

    public void addMessages(ComplexParseResult pr) {
        for (ParseResult.QueuedMessage msg : pr.queuedMessages) {
            this.queuedMessages.add(msg);
        }
    }

    @Override
    public void printMessages() {
        for (ParseResult.QueuedMessage msg : this.queuedMessages) {
            Logging.log(msg.level, msg.message, msg.stackTrace);
        }
    }

    @Override
    public void addMessagesToLog() {
        for (ParseResult.QueuedMessage msg : this.queuedMessages) {
            Logging.addParseMessage(msg.level, msg.message, msg.stackTrace);
        }
    }

    @Override
    public boolean passed() {
        for (ParseResult.QueuedMessage msg : this.queuedMessages) {
            if (msg.level != Logging.LST_ERROR) continue;
            return false;
        }
        return true;
    }

    public void copyMessages(ParseResult pr) {
        if (pr instanceof ComplexParseResult) {
            ComplexParseResult cpr = (ComplexParseResult)pr;
            for (ParseResult.QueuedMessage msg : cpr.queuedMessages) {
                this.queuedMessages.add(msg);
            }
        } else if (pr instanceof ParseResult.Fail) {
            ParseResult.Fail fail = (ParseResult.Fail)pr;
            this.queuedMessages.add(fail.getError());
        }
    }
}

