/*
 * Decompiled with CFR 0.152.
 */
package plugin.experience.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pcgen.core.utils.CoreUtility;
import pcgen.system.LanguageBundle;
import plugin.experience.ExperienceAdjusterModel;

public class ExperienceAdjusterView
extends JPanel {
    private static final int BORDER_SIZE = 6;
    private JButton addEnemyButton;
    private JButton addExperienceToCharButton;
    private JButton addExperienceToPartyButton;
    private JButton adjustCRButton;
    private JButton removeEnemyButton;
    private JLabel experienceFromCombat;
    private JLabel experienceMultLabel;
    private JLabel experienceMultNameLabel;
    private JLabel spCharLabel;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JList characterList;
    private JList enemyList;
    private JPanel jPanel1;
    private JPanel panelChar;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane scrollPaneChar;
    private JScrollPane scrollPaneEnemy;
    private JSlider experienceMultSlider;
    private JTextField experienceToAdd;
    private ExperienceAdjusterModel model;

    public ExperienceAdjusterView(ExperienceAdjusterModel model) {
        this.model = model;
        this.initComponents();
    }

    public JButton getAddEnemyButton() {
        return this.addEnemyButton;
    }

    public JButton getAddExperienceToCharButton() {
        return this.addExperienceToCharButton;
    }

    public JButton getAddExperienceToPartyButton() {
        return this.addExperienceToPartyButton;
    }

    public JButton getAdjustCRButton() {
        return this.adjustCRButton;
    }

    public JList getCharacterList() {
        return this.characterList;
    }

    public void setEnemies(DefaultListModel enemies) {
        this.enemyList.setModel(enemies);
    }

    public JList getEnemyList() {
        return this.enemyList;
    }

    public JTextField getExperienceField() {
        return this.experienceToAdd;
    }

    public void setExperienceFromCombat(int experience) {
        this.experienceFromCombat.setText(Integer.toString(experience));
    }

    public void setExperienceFromCombat(String experience) {
        this.experienceFromCombat.setText(experience);
    }

    public int getExperienceFromCombat() {
        return Integer.parseInt(this.experienceFromCombat.getText());
    }

    public JLabel getExperienceMultLabel() {
        return this.experienceMultLabel;
    }

    public JLabel getExperienceMultNameLabel() {
        return this.experienceMultNameLabel;
    }

    public JSlider getExperienceMultSlider() {
        return this.experienceMultSlider;
    }

    public void setExperienceToAdd(int experience) {
        this.experienceToAdd.setText(Integer.toString(experience));
    }

    public void setExperienceToAdd(String experience) {
        this.experienceToAdd.setText(experience);
    }

    public int getExperienceToAdd() {
        return Integer.parseInt(this.experienceToAdd.getText());
    }

    public void setParty(DefaultListModel party) {
        this.characterList.setModel(party);
    }

    public JButton getRemoveEnemyButton() {
        return this.removeEnemyButton;
    }

    private void initComponents() {
        this.jPanel5 = new JPanel();
        this.panelChar = new JPanel();
        this.characterList = new JList();
        this.spCharLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.enemyList = new JList();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel7 = new JLabel();
        this.experienceToAdd = new JTextField(6);
        this.addExperienceToCharButton = new JButton();
        this.jPanel8 = new JPanel();
        this.jLabel5 = new JLabel();
        this.experienceFromCombat = new JLabel();
        this.experienceMultNameLabel = new JLabel();
        this.experienceMultSlider = new JSlider();
        this.addExperienceToPartyButton = new JButton();
        this.experienceMultLabel = new JLabel();
        this.adjustCRButton = new JButton();
        this.addEnemyButton = new JButton();
        this.removeEnemyButton = new JButton();
        this.scrollPaneChar = new JScrollPane(this.characterList);
        this.scrollPaneEnemy = new JScrollPane(this.enemyList);
        this.setLayout(new GridLayout(0, 1));
        this.jPanel5.setBorder(new TitledBorder(LanguageBundle.getString("in_plugin_xp_char")));
        this.jPanel5.setLayout(new GridLayout(1, 0));
        this.panelChar.setLayout(new BorderLayout());
        this.spCharLabel.setText(LanguageBundle.getString("in_plugin_xp_nameLvlXp"));
        this.panelChar.add((Component)this.spCharLabel, "North");
        this.panelChar.add((Component)this.scrollPaneChar, "Center");
        this.jPanel5.add(this.panelChar);
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel4.setText(LanguageBundle.getString("in_plugin_xp_nameCr"));
        this.jPanel1.add((Component)this.jLabel4, "North");
        this.jPanel1.add((Component)this.scrollPaneEnemy, "Center");
        this.add(this.jPanel5);
        this.jPanel6.setLayout(new GridLayout(1, 0));
        this.jPanel6.setBorder(new TitledBorder(LanguageBundle.getString("in_plugin_xp_enemies")));
        this.jPanel6.add(this.jPanel1);
        this.jPanel7.setLayout(new GridBagLayout());
        this.jLabel7.setText(LanguageBundle.getString("in_plugin_xp_xpTo"));
        this.addExperienceToCharButton.setText(LanguageBundle.getString("in_plugin_xp_selectedChar"));
        this.addExperienceToCharButton.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.jPanel7.add((Component)new JLabel(LanguageBundle.getString("in_plugin_xp_add")), gridBagConstraints);
        this.jPanel7.add((Component)this.experienceToAdd, gridBagConstraints);
        this.jPanel7.add((Component)this.jLabel7, gridBagConstraints);
        this.jPanel7.add((Component)this.addExperienceToCharButton, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)new JPanel(), gridBagConstraints);
        this.characterList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ExperienceAdjusterView.this.addExperienceToCharButton.setEnabled(!ExperienceAdjusterView.this.characterList.isSelectionEmpty());
                }
            }
        });
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.jPanel5.add(this.jPanel7);
        this.jPanel8.setLayout(new GridBagLayout());
        this.jLabel5.setText(LanguageBundle.getString("in_plugin_xp_xpFromCombat"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        this.jPanel8.add((Component)this.jLabel5, gridBagConstraints);
        this.experienceFromCombat.setText(Integer.toString(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.experienceFromCombat, gridBagConstraints);
        this.experienceMultNameLabel.setText(LanguageBundle.getString("in_plugin_xp_normal"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.experienceMultNameLabel, gridBagConstraints);
        this.experienceMultSlider.setMaximum(10);
        this.experienceMultSlider.setMinimum(-5);
        this.experienceMultSlider.setValue(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel8.add((Component)this.experienceMultSlider, gridBagConstraints);
        this.experienceMultSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double realValue = ExperienceAdjusterView.this.getSliderRealValue();
                if (CoreUtility.doublesEqual(realValue, 0.5)) {
                    ExperienceAdjusterView.this.getExperienceMultNameLabel().setText(LanguageBundle.getString("in_plugin_xp_half"));
                } else if (realValue <= 0.7) {
                    ExperienceAdjusterView.this.getExperienceMultNameLabel().setText(LanguageBundle.getString("in_plugin_xp_easier"));
                } else if (realValue > 0.7 && realValue < 1.5) {
                    ExperienceAdjusterView.this.getExperienceMultNameLabel().setText(LanguageBundle.getString("in_plugin_xp_normal"));
                } else if (realValue >= 1.5) {
                    ExperienceAdjusterView.this.getExperienceMultNameLabel().setText(LanguageBundle.getString("in_plugin_xp_harder"));
                }
                if (CoreUtility.doublesEqual(realValue, 2.0)) {
                    ExperienceAdjusterView.this.getExperienceMultNameLabel().setText(LanguageBundle.getString("in_plugin_xp_twice"));
                }
                ExperienceAdjusterView.this.getExperienceMultLabel().setText(LanguageBundle.getPrettyMultiplier(realValue));
                ExperienceAdjusterView.this.model.setMultiplier(realValue);
            }
        });
        this.addExperienceToPartyButton.setText(LanguageBundle.getString("in_plugin_xp_addXpToParty"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.addExperienceToPartyButton, gridBagConstraints);
        this.experienceMultLabel.setText(LanguageBundle.getPrettyMultiplier(1.0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.experienceMultLabel, gridBagConstraints);
        this.adjustCRButton.setText(LanguageBundle.getString("in_plugin_xp_adjustCr"));
        this.adjustCRButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.adjustCRButton, gridBagConstraints);
        this.addEnemyButton.setText(LanguageBundle.getString("in_plugin_xp_addEnemy"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.addEnemyButton, gridBagConstraints);
        this.removeEnemyButton.setText(LanguageBundle.getString("in_plugin_xp_removeEnemy"));
        this.removeEnemyButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel8.add((Component)this.removeEnemyButton, gridBagConstraints);
        this.enemyList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ExperienceAdjusterView.this.adjustCRButton.setEnabled(!ExperienceAdjusterView.this.enemyList.isSelectionEmpty());
                    ExperienceAdjusterView.this.removeEnemyButton.setEnabled(!ExperienceAdjusterView.this.enemyList.isSelectionEmpty());
                }
            }
        });
        this.jPanel8.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        this.jPanel6.add(this.jPanel8);
        this.add(this.jPanel6);
    }

    private double calculateRealValue(int i) {
        return 1.0 + (double)i * 0.1;
    }

    public double getSliderRealValue() {
        return this.calculateRealValue(this.getExperienceMultSlider().getValue());
    }
}

