/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.StringTokenizer;
import pcgen.core.character.SpellBook;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;

public class SpellBookToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "SPELLBOOK";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        int bookNum = Integer.parseInt(aTok.nextToken());
        String aLabel = "NAME";
        if (aTok.hasMoreTokens()) {
            aLabel = aTok.nextToken();
        }
        SpellBook book = null;
        if (bookNum >= 0 && bookNum < display.getSpellBookCount()) {
            String bookName = display.getSpellBookNames().get(bookNum);
            book = display.getSpellBookByName(bookName);
        }
        if (book != null) {
            if ("NAME".equals(aLabel)) {
                retString = book.getName();
            } else if ("NUMPAGES".equals(aLabel)) {
                retString = String.valueOf(book.getNumPages());
            } else if ("NUMPAGESUSED".equals(aLabel)) {
                retString = String.valueOf(book.getNumPagesUsed());
            } else if ("NUMSPELLS".equals(aLabel)) {
                retString = String.valueOf(book.getNumSpells());
            } else if ("PAGEFORMULA".equals(aLabel)) {
                retString = book.getPageFormula().toString();
            } else if ("TYPE".equals(aLabel)) {
                retString = book.getTypeName();
            }
        }
        return retString;
    }
}

