/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens.deprecated;

import java.text.DecimalFormat;
import pcgen.base.math.OrderedPair;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.utils.CoreUtility;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;

public class FaceToken
extends AbstractExportToken {
    @Override
    public String getTokenName() {
        return "FACE";
    }

    @Override
    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        String retString = "";
        if ("FACE".equals(tokenSource)) {
            retString = FaceToken.getFaceToken(display);
        } else if ("FACE.SHORT".equals(tokenSource)) {
            retString = FaceToken.getShortToken(display);
        } else if ("FACE.SQUARES".equals(tokenSource)) {
            retString = FaceToken.getSquaresToken(display);
        } else if ("FACE.1".equals(tokenSource)) {
            retString = FaceToken.get1Token(display);
        } else if ("FACE.2".equals(tokenSource)) {
            retString = FaceToken.get2Token(display);
        }
        return retString;
    }

    public static String getFaceToken(CharacterDisplay display) {
        OrderedPair face = display.getFace();
        String retString = "";
        retString = CoreUtility.doublesEqual(face.getPreciseY().doubleValue(), 0.0) ? Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseX().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit() : Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseX().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit() + " by " + Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseY().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit();
        return retString;
    }

    public static String getShortToken(CharacterDisplay display) {
        OrderedPair face = display.getFace();
        String retString = "";
        retString = CoreUtility.doublesEqual(face.getPreciseY().doubleValue(), 0.0) ? Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseX().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit() : Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseX().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit() + " x " + Globals.getGameModeUnitSet().displayDistanceInUnitSet(face.getPreciseY().doubleValue()) + Globals.getGameModeUnitSet().getDistanceUnit();
        return retString;
    }

    public static String getSquaresToken(CharacterDisplay display) {
        OrderedPair face = display.getFace();
        String retString = "";
        double squareSize = SettingsHandler.getGame().getSquareSize();
        retString = CoreUtility.doublesEqual(face.getPreciseY().doubleValue(), 0.0) ? new DecimalFormat("#.#").format(face.getPreciseX().doubleValue() / squareSize) : new DecimalFormat("#.#").format(face.getPreciseX().doubleValue() / squareSize) + " x " + new DecimalFormat("#.#").format(face.getPreciseY().doubleValue() / squareSize);
        return retString;
    }

    public static String get1Token(CharacterDisplay display) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(display.getFace().getPreciseX().doubleValue());
    }

    public static String get2Token(CharacterDisplay display) {
        return Globals.getGameModeUnitSet().displayDistanceInUnitSet(display.getFace().getPreciseY().doubleValue());
    }
}

