/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import plugin.initiative.AttackModel;
import plugin.initiative.CheckModel;
import plugin.initiative.DiceRollModel;
import plugin.initiative.SaveModel;
import plugin.initiative.SkillModel;
import plugin.initiative.SpellModel;

public abstract class PObjectModel {
    protected static final int SEGMENT_POSITION_NAME = 0;
    private static final String TYPE_PREFIX_SKILL = "skill:";
    private static final String TYPE_PREFIX_CHECK = "check:";
    private static final String TYPE_PREFIX_ATTACK = "attack:";
    private static final String TYPE_PREFIX_SPELL = "spell:";
    private static final String TYPE_PREFIX_SAVE = "save:";
    private static final String TYPE_PREFIX_DICE_ROLL = "dice:";
    protected String m_name = null;
    protected String[] outputTokens = null;

    public PObjectModel(String objectString) {
        this.outputTokens = objectString.split("\\\\");
        this.m_name = this.getStringValue(this.outputTokens, 0);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public static PObjectModel Factory(String objectString) {
        PObjectModel returnValue = null;
        if (objectString != null) {
            if (objectString.startsWith(TYPE_PREFIX_SKILL)) {
                returnValue = new SkillModel(objectString.substring(TYPE_PREFIX_SKILL.length()));
            } else if (objectString.startsWith(TYPE_PREFIX_CHECK)) {
                returnValue = new CheckModel(objectString.substring(TYPE_PREFIX_CHECK.length()));
            } else if (objectString.startsWith(TYPE_PREFIX_ATTACK)) {
                returnValue = new AttackModel(objectString.substring(TYPE_PREFIX_ATTACK.length()));
            } else if (objectString.startsWith(TYPE_PREFIX_SPELL)) {
                returnValue = new SpellModel(objectString.substring(TYPE_PREFIX_SPELL.length()));
            } else if (objectString.startsWith(TYPE_PREFIX_SAVE)) {
                returnValue = new SaveModel(objectString.substring(TYPE_PREFIX_SAVE.length()));
            } else if (objectString.startsWith(TYPE_PREFIX_DICE_ROLL)) {
                returnValue = new DiceRollModel(objectString.substring(TYPE_PREFIX_DICE_ROLL.length()));
            }
        }
        return returnValue;
    }

    public String toString() {
        return this.getName();
    }

    protected static int getInt(String value) {
        int returnValue = 0;
        try {
            returnValue = value.startsWith("+") ? Integer.parseInt(value.substring(1)) : Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return returnValue;
    }

    protected String getStringValue(String[] values, int index) {
        String returnValue = "";
        if (values.length > index) {
            returnValue = values[index];
        }
        return returnValue;
    }
}

