/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.auto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.content.ConditionalSelectionActor;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.WeaponProfProvider;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.QualifiedObject;
import pcgen.core.WeaponProf;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.PreParserFactory;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class WeaponProfToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
ChooseSelectionActor<WeaponProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;

    @Override
    public String getParentToken() {
        return "AUTO";
    }

    @Override
    public String getTokenName() {
        return "WEAPONPROF";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        String weaponProfs;
        Prerequisite prereq = null;
        boolean isPre = false;
        if (value.indexOf("[") == -1) {
            weaponProfs = value;
            StringTokenizer tok = new StringTokenizer(weaponProfs, "|");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                if (!PreParserFactory.isPreReqString(token)) continue;
                if (isPre) {
                    String errorText = "Invalid " + this.getTokenName() + ": " + value + "  PRExxx must be at the END of the Token";
                    Logging.errorPrint(errorText);
                    return new ParseResult.Fail(errorText, context);
                }
                prereq = this.getPrerequisite(token);
                if (prereq == null) {
                    return new ParseResult.Fail("Error generating Prerequisite " + prereq + " in " + this.getFullName(), context);
                }
                int preStart = value.indexOf(token) - 1;
                weaponProfs = value.substring(0, preStart);
                isPre = true;
                ParseResult fail = this.checkForLoopPrereqs(prereq, context);
                if (fail == null) continue;
                return fail;
            }
        } else {
            return new ParseResult.Fail("Use of [] for Prerequisites has been removed. Please use | based standard", context);
        }
        ParseResult pr = this.checkForIllegalSeparator('|', weaponProfs);
        if (!pr.passed()) {
            return pr;
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(weaponProfs, "|");
        WeaponProfProvider wpp = new WeaponProfProvider();
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ("%LIST".equals(token)) {
                ChooseSelectionActor<WeaponProf> cra;
                foundOther = true;
                if (prereq == null) {
                    cra = this;
                } else {
                    ConditionalSelectionActor<WeaponProf> cca = new ConditionalSelectionActor<WeaponProf>(this);
                    cca.addPrerequisite(prereq);
                    cra = cca;
                }
                context.getObjectContext().addToList(obj, ListKey.NEW_CHOOSE_ACTOR, cra);
                continue;
            }
            if ("DEITYWEAPONS".equals(token)) {
                foundOther = true;
                context.getObjectContext().put(obj, ObjectKey.HAS_DEITY_WEAPONPROF, new QualifiedObject<Boolean>(Boolean.TRUE, prereq));
                continue;
            }
            if ("ALL".equalsIgnoreCase(token)) {
                foundAny = true;
                CDOMGroupRef<WeaponProf> allRef = context.getReferenceContext().getCDOMAllReference(WEAPONPROF_CLASS);
                wpp.addWeaponProfAll(allRef);
                continue;
            }
            foundOther = true;
            if (token.startsWith("TYPE.") || token.startsWith("TYPE=")) {
                CDOMGroupRef<WeaponProf> rr = TokenUtilities.getTypeReference(context, WEAPONPROF_CLASS, token.substring(5));
                if (rr == null) {
                    return ParseResult.INTERNAL_ERROR;
                }
                wpp.addWeaponProfType(rr);
                continue;
            }
            CDOMSingleRef<WeaponProf> ref = context.getReferenceContext().getCDOMReference(WEAPONPROF_CLASS, token);
            wpp.addWeaponProf(ref);
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        if (!wpp.isEmpty()) {
            if (prereq != null) {
                wpp.addPrerequisite(prereq);
            }
            context.getObjectContext().addToList(obj, ListKey.WEAPONPROF, wpp);
        }
        return ParseResult.SUCCESS;
    }

    private ParseResult checkForLoopPrereqs(Prerequisite prereq, LoadContext context) {
        if ("WEAPONPROF".equalsIgnoreCase(prereq.getKind()) && prereq.getKey().startsWith("TYPE")) {
            return new ParseResult.Fail("AUTO:WEAPONPROF may not use PREWEAPONPROF requirements  other than specific named proficiencies.", context);
        }
        for (Prerequisite childPrereq : prereq.getPrerequisites()) {
            ParseResult res = this.checkForLoopPrereqs(childPrereq, context);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        ArrayList<String> list = new ArrayList<String>();
        Changes<ChooseSelectionActor<?>> listChanges = context.getObjectContext().getListChanges(obj, ListKey.NEW_CHOOSE_ACTOR);
        Changes<WeaponProfProvider> changes = context.getObjectContext().getListChanges(obj, ListKey.WEAPONPROF);
        QualifiedObject<Boolean> deityweap = context.getObjectContext().getObject(obj, ObjectKey.HAS_DEITY_WEAPONPROF);
        Collection<WeaponProfProvider> added = changes.getAdded();
        Collection<ChooseSelectionActor<?>> listAdded = listChanges.getAdded();
        boolean foundAny = false;
        boolean foundOther = false;
        if (listAdded != null && !listAdded.isEmpty()) {
            foundOther = true;
            for (ChooseSelectionActor chooseSelectionActor : listAdded) {
                if (!chooseSelectionActor.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(chooseSelectionActor.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
            }
        }
        if (deityweap != null && deityweap.getRawObject().booleanValue()) {
            foundOther = true;
            StringBuilder sb = new StringBuilder();
            sb.append("DEITYWEAPONS");
            if (deityweap.hasPrerequisites()) {
                sb.append('|');
                sb.append(context.getPrerequisiteString(deityweap.getPrerequisiteList()));
            }
            list.add(sb.toString());
        }
        if (added != null) {
            for (WeaponProfProvider weaponProfProvider : added) {
                if (!weaponProfProvider.isValid()) {
                    context.addWriteMessage("Non-sensical WeaponProfProvider in " + this.getFullName() + ": Had invalid contents");
                    return null;
                }
                StringBuilder sb = new StringBuilder(weaponProfProvider.getLstFormat());
                List<Prerequisite> prereqs = weaponProfProvider.getPrerequisiteList();
                if (prereqs != null && !prereqs.isEmpty()) {
                    if (prereqs.size() > 1) {
                        context.addWriteMessage("Error: " + obj.getClass().getSimpleName() + " had more than one Prerequisite for " + this.getFullName());
                        return null;
                    }
                    sb.append('|');
                    sb.append(context.getPrerequisiteString(prereqs));
                }
                String lstFormat = sb.toString();
                boolean isUnconditionalAll = "ALL".equals(lstFormat);
                foundAny |= isUnconditionalAll;
                foundOther |= !isUnconditionalAll;
                list.add(lstFormat);
            }
        }
        if (foundAny && foundOther) {
            context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + list);
            return null;
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(ChooseDriver obj, WeaponProf wp, PlayerCharacter pc) {
        pc.addWeaponProf(obj, wp);
    }

    @Override
    public void removeChoice(ChooseDriver obj, WeaponProf wp, PlayerCharacter pc) {
        pc.removeWeaponProf(obj, wp);
    }

    @Override
    public Class<WeaponProf> getChoiceClass() {
        return WEAPONPROF_CLASS;
    }

    @Override
    public String getSource() {
        return this.getTokenName();
    }

    @Override
    public String getLstFormat() {
        return "%LIST";
    }
}

