/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.datacontrol;

import pcgen.base.util.FormatManager;
import pcgen.cdom.content.ContentDefinition;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class DataFormatToken
extends AbstractNonEmptyToken<ContentDefinition>
implements CDOMPrimaryToken<ContentDefinition>,
DeferredToken<ContentDefinition> {
    private static final Class<ContentDefinition> CONTENTDEF_CLASS = ContentDefinition.class;

    @Override
    public String getTokenName() {
        return "DATAFORMAT";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, ContentDefinition def, String value) {
        FormatManager<?> fmtMgr = context.getReferenceContext().getFormatManager(value);
        FormatManager<?> old = def.setFormatManager(fmtMgr);
        if (old != null && !old.equals(fmtMgr)) {
            return new ParseResult.Fail("Content Definition " + def.getClass().getSimpleName() + " " + def.getKeyName() + " was defined as " + old.getIdentifierType() + " and " + value + " (using " + value + ")");
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, ContentDefinition def) {
        FormatManager manager = def.getFormatManager();
        if (manager == null) {
            return null;
        }
        return new String[]{manager.getIdentifierType()};
    }

    @Override
    public Class<ContentDefinition> getTokenClass() {
        return CONTENTDEF_CLASS;
    }

    @Override
    public boolean process(LoadContext context, ContentDefinition def) {
        boolean isMissingFormatManager;
        boolean bl = isMissingFormatManager = def.getFormatManager() == null;
        if (isMissingFormatManager) {
            Logging.errorPrint("Content Definition " + def.getClass().getSimpleName() + " " + def.getKeyName() + " did not have a " + this.getTokenName());
        }
        return !isMissingFormatManager;
    }

    @Override
    public Class<ContentDefinition> getDeferredTokenClass() {
        return CONTENTDEF_CLASS;
    }
}

