/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.table;

import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Kit;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitTable;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.DeferredToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class TableToken
extends AbstractNonEmptyToken<KitTable>
implements CDOMPrimaryToken<KitTable>,
DeferredToken<Kit> {
    @Override
    public String getTokenName() {
        return "TABLE";
    }

    @Override
    public Class<KitTable> getTokenClass() {
        return KitTable.class;
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, KitTable kitTable, String value) {
        kitTable.setTableName(value);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, KitTable kitTable) {
        String bd = kitTable.getTableName();
        if (bd == null) {
            return null;
        }
        return new String[]{bd};
    }

    @Override
    public boolean process(LoadContext context, Kit obj) {
        for (BaseKit bk : obj.getSafeListFor(ListKey.KIT_TASKS)) {
            if (!(bk instanceof KitTable)) continue;
            obj.removeFromListFor(ListKey.KIT_TASKS, bk);
            KitTable kt = obj.addTable((KitTable)bk);
            if (kt == null) continue;
            Logging.errorPrint("Kit Table: " + kt.getTableName() + " in Kit " + obj.getKeyName() + " was a duplicate, " + "Kit had more than one table with that name.");
            return false;
        }
        return true;
    }

    @Override
    public Class<Kit> getDeferredTokenClass() {
        return Kit.class;
    }
}

