/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.util.DoubleKeyMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ClassesToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    private static final Class<ClassSpellList> SPELLLIST_CLASS = ClassSpellList.class;

    @Override
    public String getTokenName() {
        return "CLASSES";
    }

    @Override
    public ParseResult parseToken(LoadContext context, Spell spell, String value) {
        if (".CLEARALL".equals(value)) {
            context.getListContext().clearAllMasterLists(this.getTokenName(), spell);
            return ParseResult.SUCCESS;
        }
        return super.parseToken(context, spell, value);
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        String classKey;
        Prerequisite prereq = null;
        int openBracketLoc = value.indexOf(91);
        if (openBracketLoc == -1) {
            classKey = value;
        } else {
            if (value.lastIndexOf(93) != value.length() - 1) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + " must end with ']' if it contains a PREREQ tag", context);
            }
            if (value.lastIndexOf(124) > openBracketLoc) {
                return new ParseResult.Fail("Invalid " + this.getTokenName() + ": PRExxx must be at the END of the Token. Token was " + value, context);
            }
            classKey = value.substring(0, openBracketLoc);
            String prereqString = value.substring(openBracketLoc + 1, value.length() - 1);
            if (prereqString.length() == 0) {
                return new ParseResult.Fail(this.getTokenName() + " cannot have empty prerequisite : " + value, context);
            }
            prereq = this.getPrerequisite(prereqString);
            if (prereq == null) {
                return new ParseResult.Fail(this.getTokenName() + " had invalid prerequisite : " + prereqString, context);
            }
        }
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer pipeTok = new StringTokenizer(classKey, "|");
        while (pipeTok.hasMoreTokens()) {
            Integer level;
            String tokString;
            int startPos = (tokString = pipeTok.nextToken()).startsWith("TYPE=") ? "TYPE=".length() : 0;
            int equalLoc = tokString.indexOf("=", startPos);
            if (equalLoc == -1) {
                return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (expecting an =): " + tokString, context);
            }
            if (equalLoc != tokString.lastIndexOf("=")) {
                return new ParseResult.Fail("Malformed " + this.getTokenName() + " Token (more than one =): " + tokString, context);
            }
            String nameList = tokString.substring(0, equalLoc);
            String levelString = tokString.substring(equalLoc + 1);
            try {
                level = Integer.valueOf(levelString);
                if (level < -1) {
                    return new ParseResult.Fail(this.getTokenName() + " may not use a negative level: " + value, context);
                }
                if (level == -1 && prereq != null) {
                    return new ParseResult.Fail(this.getTokenName() + " may not use -1 with a PREREQ: " + value, context);
                }
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("Malformed Level in " + this.getTokenName() + " (expected an Integer): " + levelString, context);
            }
            ParseResult pr = this.checkForIllegalSeparator(',', nameList);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer commaTok = new StringTokenizer(nameList, ",");
            while (commaTok.hasMoreTokens()) {
                CDOMReference ref;
                String token = commaTok.nextToken();
                if ("ALL".equals(token)) {
                    foundAny = true;
                    ref = context.getReferenceContext().getCDOMAllReference(SPELLLIST_CLASS);
                } else {
                    foundOther = true;
                    ref = TokenUtilities.getTypeOrPrimitive(context, SPELLLIST_CLASS, token);
                    if (ref == null) {
                        return new ParseResult.Fail("  error was in " + this.getTokenName(), context);
                    }
                }
                if (level == -1) {
                    context.getListContext().removeFromMasterList(this.getTokenName(), spell, ref, spell);
                    continue;
                }
                AssociatedPrereqObject edge = context.getListContext().addToMasterList(this.getTokenName(), spell, ref, spell);
                edge.setAssociation(AssociationKey.SPELL_LEVEL, level);
                if (prereq != null) {
                    edge.addPrerequisite(prereq);
                }
                context.getObjectContext().addToList(spell, ListKey.SPELL_CLASSLEVEL, token + " " + level);
            }
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Spell spell) {
        AssociatedChanges changes;
        DoubleKeyMapToList dkmtl = new DoubleKeyMapToList();
        ArrayList<String> list = new ArrayList<String>();
        Changes<CDOMReference<ClassSpellList>> masterChanges = context.getListContext().getMasterListChanges(this.getTokenName(), spell, SPELLLIST_CLASS);
        if (masterChanges.includesGlobalClear()) {
            list.add(".CLEARALL");
        }
        if (masterChanges.hasRemovedItems()) {
            for (CDOMReference<ClassSpellList> swl : masterChanges.getRemoved()) {
                changes = context.getListContext().getChangesInMasterList(this.getTokenName(), spell, swl);
                MapToList map = changes.getRemovedAssociations();
                if (map == null || map.isEmpty()) continue;
                for (Spell added : map.getKeySet()) {
                    if (!spell.getLSTformat().equals(added.getLSTformat())) {
                        context.addWriteMessage("Spell " + this.getTokenName() + " token cannot remove another Spell " + "(must only remove itself)");
                        return null;
                    }
                    for (AssociatedPrereqObject assoc : map.getListFor((Object)added)) {
                        List<Prerequisite> prereqs = assoc.getPrerequisiteList();
                        if (prereqs != null && prereqs.size() != 0) {
                            context.addWriteMessage("Incoming Remove Edge to " + spell.getKeyName() + " had a " + "Prerequisite: " + prereqs.size());
                            return null;
                        }
                        dkmtl.addToListFor(null, (Object)-1, swl);
                    }
                }
            }
        }
        for (CDOMReference<ClassSpellList> swl : masterChanges.getAdded()) {
            changes = context.getListContext().getChangesInMasterList(this.getTokenName(), spell, swl);
            Collection removedItems = changes.getRemoved();
            if (removedItems != null && !removedItems.isEmpty() || changes.includesGlobalClear()) {
                context.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
                return null;
            }
            MapToList map = changes.getAddedAssociations();
            if (map == null || map.isEmpty()) continue;
            for (Spell added : map.getKeySet()) {
                if (!spell.getLSTformat().equals(added.getLSTformat())) {
                    context.addWriteMessage("Spell " + this.getTokenName() + " token cannot allow another Spell " + "(must only allow itself)");
                    return null;
                }
                for (AssociatedPrereqObject assoc : map.getListFor((Object)added)) {
                    Prerequisite prereq;
                    List<Prerequisite> prereqs = assoc.getPrerequisiteList();
                    if (prereqs == null || prereqs.size() == 0) {
                        prereq = null;
                    } else if (prereqs.size() == 1) {
                        prereq = prereqs.get(0);
                    } else {
                        context.addWriteMessage("Incoming Edge to " + spell.getKeyName() + " had more than one " + "Prerequisite: " + prereqs.size());
                        return null;
                    }
                    Integer level = assoc.getAssociation(AssociationKey.SPELL_LEVEL);
                    if (level == null) {
                        context.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had no Spell Level defined");
                        return null;
                    }
                    if (level < 0) {
                        context.addWriteMessage("Incoming Allows Edge to " + spell.getKeyName() + " had invalid Level: " + level + ". Must be >= 0.");
                        return null;
                    }
                    dkmtl.addToListFor((Object)prereq, (Object)level, swl);
                }
            }
        }
        if (dkmtl.isEmpty()) {
            if (list.isEmpty()) {
                return null;
            }
            return list.toArray(new String[list.size()]);
        }
        PrerequisiteWriter prereqWriter = new PrerequisiteWriter();
        TreeSet set = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        TreeSet levelSet = new TreeSet();
        for (Prerequisite prereq : dkmtl.getKeySet()) {
            StringBuilder sb = new StringBuilder();
            boolean needPipe = false;
            levelSet.clear();
            levelSet.addAll(dkmtl.getSecondaryKeySet((Object)prereq));
            for (Integer i : levelSet) {
                set.clear();
                set.addAll(dkmtl.getListFor((Object)prereq, (Object)i));
                if (needPipe) {
                    sb.append("|");
                }
                sb.append(ReferenceUtilities.joinLstFormat(set, ","));
                sb.append('=').append(i);
                needPipe = true;
            }
            if (prereq != null) {
                sb.append('[');
                StringWriter swriter = new StringWriter();
                try {
                    prereqWriter.write(swriter, prereq);
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + e);
                    return null;
                }
                sb.append(swriter.toString());
                sb.append(']');
            }
            list.add(sb.toString());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

