/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.base.util.HashMapToList;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.Vision;
import pcgen.core.prereq.Prerequisite;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;

public class VisionLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "VISION";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer aTok = new StringTokenizer(value, "|");
        String visionString = aTok.nextToken();
        if (this.looksLikeAPrerequisite(visionString)) {
            return new ParseResult.Fail("Cannot have only PRExxx subtoken in " + this.getTokenName() + ": " + value, context);
        }
        ArrayList<AssociatedPrereqObject> edgeList = new ArrayList<AssociatedPrereqObject>();
        boolean foundClear = false;
        while (true) {
            ComplexParseResult cpr;
            if (".CLEAR".equals(visionString)) {
                context.getListContext().removeAllFromList(this.getTokenName(), obj, Vision.VISIONLIST);
                foundClear = true;
            } else if (visionString.startsWith(".CLEAR.")) {
                try {
                    Vision vis = Vision.getVision((String)visionString.substring(7));
                    context.getListContext().removeFromList(this.getTokenName(), obj, Vision.VISIONLIST, (CDOMReference)new CDOMDirectSingleRef((Loadable)vis));
                }
                catch (IllegalArgumentException e) {
                    cpr = new ComplexParseResult();
                    cpr.addErrorMessage("Bad Syntax for Cleared Vision in " + this.getTokenName());
                    cpr.addErrorMessage(e.getMessage());
                    return cpr;
                }
                foundClear = true;
            } else {
                if (this.looksLikeAPrerequisite(visionString)) break;
                try {
                    Vision vision = Vision.getVision((String)visionString);
                    AssociatedPrereqObject edge = context.getListContext().addToList(this.getTokenName(), obj, Vision.VISIONLIST, (CDOMReference)new CDOMDirectSingleRef((Loadable)vision));
                    edgeList.add(edge);
                }
                catch (IllegalArgumentException e) {
                    cpr = new ComplexParseResult();
                    cpr.addErrorMessage("Bad Syntax for Vision in " + this.getTokenName());
                    cpr.addErrorMessage(e.getMessage());
                    return cpr;
                }
            }
            if (!aTok.hasMoreTokens()) {
                return ParseResult.SUCCESS;
            }
            visionString = aTok.nextToken();
        }
        if (foundClear) {
            return new ParseResult.Fail("Cannot use PREREQs when using .CLEAR or .CLEAR. in " + this.getTokenName(), context);
        }
        while (true) {
            Prerequisite prereq;
            if ((prereq = this.getPrerequisite(visionString)) == null) {
                return new ParseResult.Fail("   (Did you put vision after the PRExxx tags in " + this.getTokenName() + ":?)", context);
            }
            for (AssociatedPrereqObject edge : edgeList) {
                edge.addPrerequisite(prereq);
            }
            if (!aTok.hasMoreTokens()) break;
            visionString = aTok.nextToken();
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject obj) {
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), obj, Vision.VISIONLIST);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (changes.includesGlobalClear()) {
            if (removedItems != null && !removedItems.isEmpty()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR");
        } else if (removedItems != null && !removedItems.isEmpty()) {
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)"|.CLEAR."));
        }
        MapToList mtl = changes.getAddedAssociations();
        if (mtl != null && !mtl.isEmpty()) {
            HashMapToList m = new HashMapToList();
            for (CDOMReference ab : mtl.getKeySet()) {
                for (AssociatedPrereqObject assoc : mtl.getListFor((Object)ab)) {
                    m.addAllToListFor(new HashSet(assoc.getPrerequisiteList()), ab.getContainedObjects());
                }
            }
            TreeSet<String> set = new TreeSet<String>();
            for (Set prereqs : m.getKeySet()) {
                StringBuilder sb = new StringBuilder(StringUtil.join((Collection)m.getListFor((Object)prereqs), (String)"|"));
                if (prereqs != null && !prereqs.isEmpty()) {
                    sb.append("|");
                    sb.append(this.getPrerequisiteString(context, prereqs));
                }
                set.add(sb.toString());
            }
            list.addAll(set);
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

