/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.sizeadjustment;

import java.util.Collection;
import java.util.TreeMap;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.SizeAdjustment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractIntToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.PostValidationToken;
import pcgen.util.Logging;

public class SizeNumToken
extends AbstractIntToken<SizeAdjustment>
implements CDOMPrimaryToken<SizeAdjustment>,
PostValidationToken<SizeAdjustment> {
    public String getTokenName() {
        return "SIZENUM";
    }

    protected IntegerKey integerKey() {
        return IntegerKey.SIZENUM;
    }

    protected int minValue() {
        return 0;
    }

    public Class<SizeAdjustment> getTokenClass() {
        return SizeAdjustment.class;
    }

    public boolean process(LoadContext context, Collection<? extends SizeAdjustment> obj) {
        Collection<Object> ordered;
        boolean returnValue = true;
        boolean hasAny = false;
        for (SizeAdjustment sizeAdjustment : obj) {
            if (sizeAdjustment.get(IntegerKey.SIZENUM) == null) continue;
            hasAny = true;
        }
        if (hasAny) {
            TreeMap<Integer, SizeAdjustment> map = new TreeMap<Integer, SizeAdjustment>();
            for (SizeAdjustment sizeAdjustment : obj) {
                Integer sizenum = sizeAdjustment.get(IntegerKey.SIZENUM);
                if (sizenum == null) {
                    Logging.errorPrint((String)("Size: " + sizeAdjustment.getKeyName() + " did not have a SIZENUM (cannot be assumed)"));
                    returnValue = false;
                    continue;
                }
                SizeAdjustment previous = map.put(sizenum, sizeAdjustment);
                if (previous == null) continue;
                Logging.errorPrint((String)("Size: " + sizeAdjustment.getKeyName() + " and size: " + previous.getKeyName() + " had identical SIZENUM: " + sizenum));
                returnValue = false;
            }
            ordered = map.values();
        } else {
            Logging.deprecationPrint((String)"SizeAdjustment items must have a SIZENUM", (LoadContext)context);
            ordered = context.getReferenceContext().getOrderSortedCDOMObjects(SizeAdjustment.class);
        }
        int order = 0;
        for (SizeAdjustment sizeAdjustment : ordered) {
            sizeAdjustment.put(IntegerKey.SIZEORDER, Integer.valueOf(order++));
        }
        return returnValue;
    }

    public Class<SizeAdjustment> getValidationTokenClass() {
        return SizeAdjustment.class;
    }

    public int getPriority() {
        return 1;
    }
}

