/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.equipment;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.helper.EqModRef;
import pcgen.cdom.inst.EquipmentHead;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.rules.context.AbstractObjectContext;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class EqmodToken
extends AbstractTokenWithSeparator<Equipment>
implements CDOMPrimaryToken<Equipment> {
    private static final Class<EquipmentModifier> EQMOD_CLASS = EquipmentModifier.class;
    private static final String EQMOD_WEIGHT = "_WEIGHTADD";
    private static final String EQMOD_DAMAGE = "_DAMAGE";

    public String getTokenName() {
        return "EQMOD";
    }

    protected char separator() {
        return '.';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Equipment eq, String value) {
        StringTokenizer dotTok = new StringTokenizer(value, ".");
        EquipmentHead head = eq.getEquipmentHead(1);
        while (dotTok.hasMoreTokens()) {
            String modInfo = dotTok.nextToken();
            if (modInfo.equalsIgnoreCase("None")) {
                Logging.deprecationPrint((String)("'NONE' EqMod in " + this.getTokenName() + " will be ignored"), (LoadContext)context);
                continue;
            }
            ParseResult pr = this.checkForIllegalSeparator('|', modInfo);
            if (!pr.passed()) {
                return pr;
            }
            StringTokenizer aTok = new StringTokenizer(modInfo, "|");
            String eqModKey = aTok.nextToken();
            if (eqModKey.equals(EQMOD_WEIGHT)) {
                if (!aTok.hasMoreTokens()) continue;
                context.getObjectContext().put((CDOMObject)eq, ObjectKey.WEIGHT_MOD, (Object)new BigDecimal(aTok.nextToken().replace(',', '.')));
                continue;
            }
            if (eqModKey.equals(EQMOD_DAMAGE)) {
                if (!aTok.hasMoreTokens()) continue;
                context.getObjectContext().put((CDOMObject)eq, StringKey.DAMAGE_OVERRIDE, aTok.nextToken());
                continue;
            }
            CDOMSingleRef ref = context.getReferenceContext().getCDOMReference(EQMOD_CLASS, eqModKey);
            EqModRef modref = new EqModRef(ref);
            while (aTok.hasMoreTokens()) {
                modref.addChoice(aTok.nextToken().replace('=', '|'));
            }
            context.getObjectContext().addToList((CDOMObject)head, ListKey.EQMOD_INFO, (Object)modref);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Equipment eq) {
        Changes changes;
        Collection added;
        EquipmentHead head;
        BigDecimal weight;
        AbstractObjectContext obj = context.getObjectContext();
        String damage = obj.getString((CDOMObject)eq, StringKey.DAMAGE_OVERRIDE);
        TreeSet<String> set = new TreeSet<String>();
        if (damage != null) {
            set.add("_DAMAGE|" + damage);
        }
        if ((weight = (BigDecimal)obj.getObject((CDOMObject)eq, ObjectKey.WEIGHT_MOD)) != null) {
            set.add("_WEIGHTADD|" + weight.toString().replace('.', ','));
        }
        if ((head = eq.getEquipmentHeadReference(1)) != null && (added = (changes = obj.getListChanges((CDOMObject)head, ListKey.EQMOD_INFO)).getAdded()) != null) {
            for (EqModRef modRef : added) {
                String key = modRef.getRef().getLSTformat(false);
                StringBuilder sb = new StringBuilder();
                sb.append(key);
                for (String s : modRef.getChoices()) {
                    sb.append("|");
                    sb.append(s.replace('|', '='));
                }
                set.add(sb.toString());
            }
        }
        if (set.isEmpty()) {
            return null;
        }
        return new String[]{StringUtil.join(set, (String)".")};
    }

    public Class<Equipment> getTokenClass() {
        return Equipment.class;
    }
}

