/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.template;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Loadable;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCTemplate;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ComplexParseResult;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class LevelToken
extends AbstractTokenWithSeparator<PCTemplate>
implements CDOMPrimaryToken<PCTemplate> {
    public String getTokenName() {
        return "LEVEL";
    }

    public ParseResult parseToken(LoadContext context, PCTemplate template, String value) {
        if (".CLEAR".equals(value)) {
            context.getObjectContext().removeList((CDOMObject)template, ListKey.LEVEL_TEMPLATES);
            return ParseResult.SUCCESS;
        }
        return super.parseToken(context, (Object)template, value);
    }

    protected char separator() {
        return ':';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, PCTemplate template, String value) {
        int lvl;
        StringTokenizer tok = new StringTokenizer(value, ":");
        String levelStr = tok.nextToken();
        int plusLoc = levelStr.indexOf(43);
        if (plusLoc == 0) {
            return new ParseResult.Fail("Malformed " + this.getTokenName() + " Level cannot start with +: " + value, context);
        }
        try {
            lvl = Integer.parseInt(levelStr);
            if (lvl <= 0) {
                ComplexParseResult cpr = new ComplexParseResult();
                cpr.addErrorMessage("Malformed " + this.getTokenName() + " Token (Level was <= 0): " + lvl);
                cpr.addErrorMessage("  Line was: " + value);
                return cpr;
            }
        }
        catch (NumberFormatException ex) {
            return new ParseResult.Fail("Misunderstood Level value: " + levelStr + " in " + this.getTokenName(), context);
        }
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail("Invalid " + this.getTokenName() + ": requires 3 colon separated elements (has one): " + value, context);
        }
        String typeStr = tok.nextToken();
        if (!tok.hasMoreTokens()) {
            return new ParseResult.Fail("Invalid " + this.getTokenName() + ": requires 3 colon separated elements (has two): " + value, context);
        }
        String argument = tok.nextToken();
        PCTemplate derivative = new PCTemplate();
        derivative.put(ObjectKey.VISIBILITY, (Object)Visibility.HIDDEN);
        derivative.put(IntegerKey.LEVEL, Integer.valueOf(lvl));
        context.getReferenceContext().getManufacturer(PCTemplate.class).addDerivativeObject((Loadable)derivative);
        context.getObjectContext().addToList((CDOMObject)template, ListKey.LEVEL_TEMPLATES, (Object)derivative);
        try {
            if (context.processToken((Loadable)derivative, typeStr, argument)) {
                return ParseResult.SUCCESS;
            }
        }
        catch (PersistenceLayerException e) {
            return new ParseResult.Fail(e.getMessage(), context);
        }
        return ParseResult.INTERNAL_ERROR;
    }

    public String[] unparse(LoadContext context, PCTemplate pct) {
        Changes changes = context.getObjectContext().getListChanges((CDOMObject)pct, ListKey.LEVEL_TEMPLATES);
        Collection added = changes.getAdded();
        ArrayList<String> ret = new ArrayList<String>();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            ret.add(".CLEAR");
        }
        if (added != null) {
            TreeSet<String> set = new TreeSet<String>();
            for (PCTemplate pctChild : added) {
                StringBuilder sb = new StringBuilder();
                sb.append(pctChild.get(IntegerKey.LEVEL)).append(':');
                Collection unparse = context.unparse((Object)pctChild);
                if (unparse == null) continue;
                int masterLength = sb.length();
                for (String str : unparse) {
                    sb.setLength(masterLength);
                    set.add(sb.append(str).toString());
                }
            }
            ret.addAll(set);
        }
        if (ret.isEmpty()) {
            return null;
        }
        return ret.toArray(new String[ret.size()]);
    }

    public Class<PCTemplate> getTokenClass() {
        return PCTemplate.class;
    }
}

