/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.graph.inst;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.graph.base.Edge;
import pcgen.base.graph.base.Graph;
import pcgen.base.graph.base.GraphChangeListener;
import pcgen.base.graph.inst.GraphChangeSupport;

public abstract class AbstractSetMapGraph<N, ET extends Edge<N>>
implements Graph<N, ET> {
    private final Map<N, N> nodeMap;
    private final Set<ET> edgeSet = new HashSet<ET>();
    private final transient Map<N, Set<ET>> nodeEdgeMap;
    private final GraphChangeSupport<N, ET> gcs;

    public AbstractSetMapGraph() {
        this.nodeMap = new HashMap<N, N>();
        this.gcs = new GraphChangeSupport(this);
        this.nodeEdgeMap = new HashMap<N, Set<ET>>();
    }

    @Override
    public boolean addNode(N node) {
        if (node == null) {
            return false;
        }
        if (this.nodeMap.containsKey(node)) {
            return false;
        }
        this.nodeMap.put(node, node);
        this.nodeEdgeMap.put(node, new HashSet());
        this.gcs.fireGraphNodeChangeEvent(node, 0);
        return true;
    }

    public N getInternalizedNode(N node) {
        if (node == null) {
            return null;
        }
        return this.nodeMap.get(node);
    }

    @Override
    public boolean addEdge(ET edge) {
        if (edge == null) {
            return false;
        }
        boolean added = this.edgeSet.add(edge);
        if (!added) {
            return false;
        }
        List graphNodes = edge.getAdjacentNodes();
        for (Object node : graphNodes) {
            this.addNode(node);
            this.nodeEdgeMap.get(node).add(edge);
        }
        this.gcs.fireGraphEdgeChangeEvent(edge, 0);
        return true;
    }

    @Override
    public boolean containsNode(Object node) {
        return this.nodeEdgeMap.containsKey(node);
    }

    @Override
    public boolean containsEdge(Edge<?> edge) {
        return this.edgeSet.contains(edge);
    }

    @Override
    public List<N> getNodeList() {
        return new ArrayList<N>(this.nodeMap.keySet());
    }

    @Override
    public List<ET> getEdgeList() {
        return new ArrayList<ET>(this.edgeSet);
    }

    @Override
    public boolean removeNode(N node) {
        if (node == null) {
            return false;
        }
        if (!this.containsNode(node)) {
            return false;
        }
        for (Edge edge : this.nodeEdgeMap.remove(node)) {
            this.removeEdge(edge);
        }
        this.nodeMap.remove(node);
        this.gcs.fireGraphNodeChangeEvent(node, 1);
        return true;
    }

    @Override
    public boolean removeEdge(ET edge) {
        if (edge == null) {
            return false;
        }
        boolean removed = this.edgeSet.remove(edge);
        if (!removed) {
            return false;
        }
        List graphNodes = edge.getAdjacentNodes();
        for (Object node : graphNodes) {
            Set<ET> adjacentEdges = this.nodeEdgeMap.get(node);
            if (adjacentEdges == null) continue;
            adjacentEdges.remove(edge);
        }
        this.gcs.fireGraphEdgeChangeEvent(edge, 1);
        return true;
    }

    @Override
    public Set<ET> getAdjacentEdges(N node) {
        Set<ET> s = this.nodeEdgeMap.get(node);
        return s == null ? null : new HashSet<ET>(s);
    }

    @Override
    public void addGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.gcs.addGraphChangeListener(listener);
    }

    @Override
    public GraphChangeListener<N, ET>[] getGraphChangeListeners() {
        return this.gcs.getGraphChangeListeners();
    }

    @Override
    public void removeGraphChangeListener(GraphChangeListener<N, ET> listener) {
        this.gcs.removeGraphChangeListener(listener);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Graph)) {
            return false;
        }
        Graph otherGraph = (Graph)other;
        List otherNodeList = otherGraph.getNodeList();
        int thisNodeSize = this.nodeMap.size();
        if (thisNodeSize != otherNodeList.size()) {
            return false;
        }
        if ((otherNodeList = new ArrayList(otherNodeList)).retainAll(this.nodeMap.keySet())) {
            ArrayList<N> al = new ArrayList<N>(this.nodeMap.keySet());
            al.removeAll(otherNodeList);
            ArrayList al2 = new ArrayList(otherGraph.getNodeList());
            al2.removeAll(otherNodeList);
            return false;
        }
        List otherEdgeList = otherGraph.getEdgeList();
        int thisEdgeSize = this.edgeSet.size();
        if (thisEdgeSize != otherEdgeList.size()) {
            return false;
        }
        return !(otherEdgeList = new ArrayList(otherEdgeList)).retainAll(this.edgeSet);
    }

    @Override
    public int hashCode() {
        return this.nodeMap.size() + this.edgeSet.size() * 23;
    }

    @Override
    public boolean isEmpty() {
        return this.nodeMap.isEmpty() && this.edgeSet.isEmpty();
    }

    @Override
    public int getNodeCount() {
        return this.nodeMap.size();
    }

    @Override
    public void clear() {
        this.nodeEdgeMap.clear();
        this.nodeMap.clear();
        this.edgeSet.clear();
    }
}

