/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.GenericMapToList;
import pcgen.base.util.MapToList;
import pcgen.base.util.WrappedMapSet;

public class DoubleKeyMapToList<K1, K2, V>
implements Cloneable {
    private final Class<? extends Map> firstClass;
    private final Class<? extends Map> secondClass;
    private Map<K1, MapToList<K2, V>> mtmtl;

    public DoubleKeyMapToList() {
        this.firstClass = HashMap.class;
        this.secondClass = this.firstClass;
        this.mtmtl = new HashMap<K1, MapToList<K2, V>>();
    }

    public DoubleKeyMapToList(Class<? extends Map> cl1, Class<? extends Map> cl2) {
        if (cl1 == null) {
            throw new IllegalArgumentException("First underlying Class cannot be null for DoubleKeyMapToList");
        }
        if (cl2 == null) {
            throw new IllegalArgumentException("Second underlying Class cannot be null for DoubleKeyMapToList");
        }
        this.firstClass = cl1;
        this.secondClass = cl2;
        this.mtmtl = this.createGlobalMap();
        GenericMapToList.getMapToList(this.secondClass);
    }

    public void addToListFor(K1 key1, K2 key2, V valueElement) {
        this.getMapToListFor(key1).addToListFor(key2, valueElement);
    }

    public void addAllToListFor(K1 key1, K2 key2, Collection<V> values) {
        this.getMapToListFor(key1).addAllToListFor(key2, values);
    }

    public void addAll(DoubleKeyMapToList<K1, K2, V> dkmtl) {
        for (Map.Entry<K1, MapToList<K2, V>> me : dkmtl.mtmtl.entrySet()) {
            MapToList<K2, V> localMap = this.getMapToListFor(me.getKey());
            localMap.addAllLists(me.getValue());
        }
    }

    public List<V> getListFor(K1 key1, K2 key2) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            return null;
        }
        return localMap.getListFor(key2);
    }

    public boolean containsListFor(K1 key1) {
        return this.mtmtl.containsKey(key1);
    }

    public boolean containsListFor(K1 key1, K2 key2) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            return false;
        }
        return localMap.containsListFor(key2);
    }

    public MapToList<K2, V> removeListsFor(K1 key1) {
        return this.mtmtl.remove(key1);
    }

    public List<V> removeListFor(K1 key1, K2 key2) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            return null;
        }
        List<V> removed = localMap.removeListFor(key2);
        if (localMap.isEmpty()) {
            this.mtmtl.remove(key1);
        }
        return removed;
    }

    public boolean removeFromListFor(K1 key1, K2 key2, V valueElement) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            return false;
        }
        boolean wasRemoved = localMap.removeFromListFor(key2, valueElement);
        if (wasRemoved && localMap.isEmpty()) {
            this.mtmtl.remove(key1);
        }
        return wasRemoved;
    }

    public Set<K1> getKeySet() {
        return new WrappedMapSet<K1>(this.firstClass, this.mtmtl.keySet());
    }

    public Set<K2> getSecondaryKeySet(K1 key1) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            return Collections.emptySet();
        }
        return localMap.getKeySet();
    }

    public void clear() {
        this.mtmtl.clear();
    }

    public boolean isEmpty() {
        return this.mtmtl.isEmpty();
    }

    public int firstKeyCount() {
        return this.mtmtl.size();
    }

    public DoubleKeyMapToList<K1, K2, V> clone() throws CloneNotSupportedException {
        DoubleKeyMapToList dkm = (DoubleKeyMapToList)super.clone();
        dkm.mtmtl = this.createGlobalMap();
        for (K1 key : this.mtmtl.keySet()) {
            MapToList<K2, V> currentMTL = this.mtmtl.get(key);
            GenericMapToList<K2, V> newMTL = GenericMapToList.getMapToList(this.secondClass);
            newMTL.addAllLists(currentMTL);
            dkm.mtmtl.put(key, newMTL);
        }
        return dkm;
    }

    public boolean containsInList(K1 key1, K2 key2, V valueElement) {
        return this.containsListFor(key1, key2) && this.mtmtl.get(key1).containsInList(key2, valueElement);
    }

    public int sizeOfListFor(K1 key1, K2 key2) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        return localMap == null ? 0 : localMap.sizeOfListFor(key2);
    }

    public int hashCode() {
        return this.mtmtl.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof DoubleKeyMapToList && this.mtmtl.equals(((DoubleKeyMapToList)obj).mtmtl);
    }

    private Map<K1, MapToList<K2, V>> createGlobalMap() {
        try {
            return this.firstClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", e);
        }
    }

    private MapToList<K2, V> getMapToListFor(K1 key1) {
        MapToList<K2, V> localMap = this.mtmtl.get(key1);
        if (localMap == null) {
            localMap = GenericMapToList.getMapToList(this.secondClass);
            this.mtmtl.put(key1, localMap);
        }
        return localMap;
    }
}

