/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;

public class ListSet<T>
extends AbstractSet<T>
implements Set<T> {
    private final Comparator<T> comparator;
    private final ArrayList<T> list;

    public ListSet() {
        this(10, null);
    }

    public ListSet(int size) {
        this(size, null);
    }

    public ListSet(Comparator<T> comp) {
        this(10, comp);
    }

    public ListSet(int size, Comparator<T> comp) {
        this.list = new ArrayList(size);
        this.comparator = comp;
    }

    public ListSet(Collection<T> otherSet) {
        this.list = new ArrayList<T>(otherSet);
        this.comparator = null;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean add(T element) {
        boolean contains = false;
        if (this.comparator == null) {
            contains = this.list.contains(element);
        } else {
            Iterator<T> it = this.list.iterator();
            while (it.hasNext()) {
                if (this.comparator.compare(it.next(), element) != 0) continue;
                contains = true;
                break;
            }
        }
        if (!contains) {
            return this.list.add(element);
        }
        return false;
    }

    public void ensureCapacity(int capacity) {
        this.list.ensureCapacity(capacity);
    }

    public void trimToSize() {
        this.list.trimToSize();
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    @Override
    public boolean contains(Object element) {
        if (this.comparator == null) {
            return this.list.contains(element);
        }
        Object comp = element;
        Iterator<T> it = this.list.iterator();
        while (it.hasNext()) {
            if (this.comparator.compare(comp, it.next()) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean remove(Object element) {
        if (this.comparator == null) {
            return this.list.remove(element);
        }
        Object comp = element;
        Iterator<T> it = this.list.iterator();
        while (it.hasNext()) {
            if (this.comparator.compare(comp, it.next()) != 0) continue;
            it.remove();
            return true;
        }
        return false;
    }
}

