/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class VisibleToken
extends AbstractNonEmptyToken<PCClass>
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "VISIBLE";
    }

    protected ParseResult parseNonEmptyToken(LoadContext context, PCClass pcc, String value) {
        Visibility vis;
        if (value.equals("NO")) {
            vis = Visibility.HIDDEN;
        } else if (value.equalsIgnoreCase("Y") || value.equals("YES")) {
            vis = Visibility.DEFAULT;
        } else {
            return new ParseResult.Fail("Can't understand Visibility: " + value, context);
        }
        context.getObjectContext().put((CDOMObject)pcc, ObjectKey.VISIBILITY, (Object)vis);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        String visString;
        Visibility vis = (Visibility)context.getObjectContext().getObject((CDOMObject)pcc, ObjectKey.VISIBILITY);
        if (vis == null) {
            return null;
        }
        if (vis.equals((Object)Visibility.DEFAULT)) {
            visString = "YES";
        } else if (vis.equals((Object)Visibility.HIDDEN)) {
            visString = "NO";
        } else {
            context.addWriteMessage("Visibility " + vis + " is not a valid Visibility for a PCClass");
            return null;
        }
        return new String[]{visString};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

