/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class CSSImportRuleImpl
implements CSSImportRule,
Serializable {
    CSSStyleSheetImpl _parentStyleSheet = null;
    CSSRule _parentRule = null;
    String _href = null;
    MediaList _media = null;

    public CSSImportRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, String href, MediaList media) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._href = href;
        this._media = media;
    }

    public short getType() {
        return 3;
    }

    public String getCssText() {
        StringBuffer sb = new StringBuffer();
        sb.append("@import url(").append(this.getHref()).append(")");
        if (this.getMedia().getLength() > 0) {
            sb.append(" ").append(this.getMedia().toString());
        }
        sb.append(";");
        return sb.toString();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 3) {
                throw new DOMExceptionImpl(13, 6);
            }
            this._href = ((CSSImportRuleImpl)r)._href;
            this._media = ((CSSImportRuleImpl)r)._media;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getHref() {
        return this._href;
    }

    public MediaList getMedia() {
        return this._media;
    }

    public CSSStyleSheet getStyleSheet() {
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

