/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.NameValuePair;
import org.lobobrowser.util.Objects;
import org.lobobrowser.util.Strings;

public class Urls {
    private static final Logger logger = Logger.getLogger(Urls.class.getName());
    public static final DateFormat PATTERN_RFC1123;

    private Urls() {
    }

    public static boolean isLocal(URL url) {
        if (Urls.isLocalFile(url)) {
            return true;
        }
        String protocol = url.getProtocol();
        if ("jar".equalsIgnoreCase(protocol)) {
            String path = url.getPath();
            int emIdx = path.lastIndexOf(33);
            String subUrlString = emIdx == -1 ? path : path.substring(0, emIdx);
            try {
                URL subUrl = new URL(subUrlString);
                return Urls.isLocal(subUrl);
            }
            catch (MalformedURLException mfu) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLocalFile(URL url) {
        String scheme = url.getProtocol();
        return "file".equalsIgnoreCase(scheme) && !Urls.hasHost(url);
    }

    public static boolean hasHost(URL url) {
        String host = url.getHost();
        return host != null && !"".equals(host);
    }

    public static URL createURL(URL baseUrl, String relativeUrl) throws MalformedURLException {
        return new URL(baseUrl, relativeUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getExpiration(URLConnection connection, long baseTime) {
        String expires;
        Object token;
        String cacheControl = connection.getHeaderField("Cache-Control");
        if (cacheControl != null) {
            StringTokenizer tok = new StringTokenizer(cacheControl, ",");
            while (tok.hasMoreTokens()) {
                int eqIdx;
                token = tok.nextToken().trim().toLowerCase();
                if ("must-revalidate".equals(token)) {
                    return new Long(0L);
                }
                if (!((String)token).startsWith("max-age") || (eqIdx = ((String)token).indexOf(61)) == -1) continue;
                String value = ((String)token).substring(eqIdx + 1).trim();
                try {
                    int seconds = Integer.parseInt(value);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    logger.warning("getExpiration(): Bad Cache-Control max-age value: " + value);
                }
            }
        }
        if ((expires = connection.getHeaderField("Expires")) != null) {
            try {
                token = PATTERN_RFC1123;
                synchronized (token) {
                    Date expDate = PATTERN_RFC1123.parse(expires);
                    return new Long(expDate.getTime());
                }
            }
            catch (ParseException pe) {
                try {
                    int seconds = Integer.parseInt(expires);
                    return new Long(baseTime + (long)(seconds * 1000));
                }
                catch (NumberFormatException nfe) {
                    logger.warning("getExpiration(): Bad Expires header value: " + expires);
                }
            }
        }
        return null;
    }

    public static List getHeaders(URLConnection connection) {
        String value;
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>();
        int n = 0;
        while ((value = connection.getHeaderField(n)) != null) {
            String key = connection.getHeaderFieldKey(n);
            if (key != null) {
                headers.add(new NameValuePair(key, value));
            }
            ++n;
        }
        return headers;
    }

    public static URL guessURL(URL baseURL, String spec) throws MalformedURLException {
        URL finalURL;
        try {
            if (baseURL != null) {
                String newProtocol;
                int colonIdx = spec.indexOf(58);
                String string = newProtocol = colonIdx == -1 ? null : spec.substring(0, colonIdx);
                if (newProtocol != null && !newProtocol.equalsIgnoreCase(baseURL.getProtocol())) {
                    baseURL = null;
                }
            }
            finalURL = Urls.createURL(baseURL, spec);
        }
        catch (MalformedURLException mfu) {
            spec = spec.trim();
            int idx = spec.indexOf(58);
            if (idx == -1) {
                String possibleHost;
                int slashIdx = spec.indexOf(47);
                finalURL = slashIdx == 0 ? new URL("file:" + spec) : (slashIdx == -1 ? new URL(baseURL, "http://" + spec) : (Domains.isLikelyHostName(possibleHost = spec.substring(0, slashIdx).toLowerCase()) ? new URL(baseURL, "http://" + spec) : new URL(baseURL, "file:" + spec)));
            }
            if (idx == 1) {
                finalURL = new URL(baseURL, "file:" + spec);
            }
            throw mfu;
        }
        if (!"".equals(finalURL.getHost()) && finalURL.toExternalForm().indexOf(32) != -1) {
            throw new MalformedURLException("There are blanks in the URL: " + finalURL.toExternalForm());
        }
        return finalURL;
    }

    public static URL guessURL(String spec) throws MalformedURLException {
        return Urls.guessURL(null, spec);
    }

    public static String getCharset(URLConnection connection) {
        String contentType = connection.getContentType();
        if (contentType == null) {
            return Urls.getDefaultCharset(connection);
        }
        StringTokenizer tok = new StringTokenizer(contentType, ";");
        if (tok.hasMoreTokens()) {
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                String varName;
                String assignment = tok.nextToken().trim();
                int eqIdx = assignment.indexOf(61);
                if (eqIdx == -1 || !"charset".equalsIgnoreCase(varName = assignment.substring(0, eqIdx).trim())) continue;
                String varValue = assignment.substring(eqIdx + 1);
                return Strings.unquote(varValue.trim());
            }
        }
        return Urls.getDefaultCharset(connection);
    }

    private static String getDefaultCharset(URLConnection connection) {
        URL url = connection.getURL();
        if (Urls.isLocalFile(url)) {
            String charset = System.getProperty("file.encoding");
            return charset == null ? "ISO-8859-1" : charset;
        }
        return "ISO-8859-1";
    }

    public static String getNoRefForm(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        String portText = port == -1 ? "" : ":" + port;
        String userInfo = url.getUserInfo();
        String userInfoText = userInfo == null || userInfo.length() == 0 ? "" : userInfo + "@";
        String hostPort = host == null || host.length() == 0 ? "" : "//" + userInfoText + host + portText;
        return url.getProtocol() + ":" + hostPort + url.getFile();
    }

    public static boolean sameNoRefURL(URL url1, URL url2) {
        return Objects.equals(url1.getHost(), url2.getHost()) && Objects.equals(url1.getProtocol(), url2.getProtocol()) && url1.getPort() == url2.getPort() && Objects.equals(url1.getFile(), url2.getFile()) && Objects.equals(url1.getUserInfo(), url2.getUserInfo());
    }

    static {
        DateFormat df = PATTERN_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

