/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.ChoiceActor;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcreteTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.NonInteractive;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.base.Ungranted;
import pcgen.cdom.choiceset.SimpleChoiceSet;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.core.PlayerCharacter;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class RegionLst
extends AbstractTokenWithSeparator<CDOMObject>
implements CDOMPrimaryToken<CDOMObject>,
ChoiceActor<Region> {
    public String getTokenName() {
        return "REGION";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, CDOMObject obj, String value) {
        if (obj instanceof Ungranted) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Ungranted object type: " + obj.getClass().getSimpleName(), context);
        }
        if (obj instanceof NonInteractive) {
            return new ParseResult.Fail("Cannot use " + this.getTokenName() + " on an Non-Interactive object type: " + obj.getClass().getSimpleName(), context);
        }
        StringTokenizer tok = new StringTokenizer(value, "|");
        String item = tok.nextToken();
        Formula count = FormulaFactory.getFormulaFor((String)item);
        if (!count.isValid()) {
            return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
        }
        if (count.isStatic()) {
            if (!tok.hasMoreTokens()) {
                return new ParseResult.Fail(this.getTokenName() + " cannot have only a count: " + value, context);
            }
            item = tok.nextToken();
            if (count.resolveStatic().intValue() <= 0) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " must be > 0: " + value, context);
            }
        } else {
            count = FormulaFactory.ONE;
        }
        ArrayList<Region> regions = new ArrayList<Region>();
        while (true) {
            regions.add(Region.getConstant((String)item));
            if (!tok.hasMoreTokens()) break;
            item = tok.nextToken();
        }
        SimpleChoiceSet rcs = new SimpleChoiceSet(regions);
        ChoiceSet cs = new ChoiceSet(this.getTokenName(), (PrimitiveChoiceSet)rcs);
        cs.setTitle("Region Selection");
        ConcreteTransitionChoice tc = new ConcreteTransitionChoice((SelectableSet)cs, count);
        context.getObjectContext().put(obj, ObjectKey.REGION_CHOICE, (Object)tc);
        tc.setRequired(false);
        tc.setChoiceActor((ChoiceActor)this);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, CDOMObject pcc) {
        TransitionChoice tc = (TransitionChoice)context.getObjectContext().getObject(pcc, ObjectKey.REGION_CHOICE);
        if (tc == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Formula count = tc.getCount();
        if (!FormulaFactory.ONE.equals(count)) {
            sb.append(count);
            sb.append("|");
        }
        sb.append(tc.getChoices().getLSTformat().replaceAll(",", "|"));
        return new String[]{sb.toString()};
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    public void applyChoice(CDOMObject owner, Region choice, PlayerCharacter pc) {
        if (!pc.getDisplay().getRegionString().equalsIgnoreCase(choice.toString())) {
            pc.setRegion(choice);
        }
    }

    public boolean allow(Region choice, PlayerCharacter pc, boolean allowStack) {
        return true;
    }
}

