/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParameterRole;
import freemarker.core.StopException;
import freemarker.core.TemplateElement;
import freemarker.debug.impl.DebuggerService;
import freemarker.template.TemplateException;
import java.io.IOException;

public class DebugBreak
extends TemplateElement {
    public DebugBreak(TemplateElement nestedBlock) {
        this.setNestedBlock(nestedBlock);
        this.copyLocationFrom(nestedBlock);
    }

    protected void accept(Environment env) throws TemplateException, IOException {
        if (DebuggerService.suspendEnvironment(env, this.getTemplate().getSourceName(), this.getNestedBlock().getBeginLine())) {
            throw new StopException(env, "Stopped by debugger");
        }
        this.getNestedBlock().accept(env);
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            StringBuffer sb = new StringBuffer();
            sb.append("<#-- ");
            sb.append("debug break");
            if (this.getNestedBlock() == null) {
                sb.append(" /-->");
            } else {
                sb.append(" -->");
                sb.append(this.getNestedBlock().getCanonicalForm());
                sb.append("<#--/ debug break -->");
            }
            return sb.toString();
        }
        return "debug break";
    }

    String getNodeTypeSymbol() {
        return "#debug_break";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

