/*
 * Decompiled with CFR 0.152.
 */
package plugin.pretokens.parser;

import java.util.ArrayList;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.prereq.AbstractPrerequisiteListParser;
import pcgen.persistence.lst.prereq.PrerequisiteParserInterface;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public class PreAbilityParser
extends AbstractPrerequisiteListParser
implements PrerequisiteParserInterface {
    private static final String CATEGORY = "CATEGORY.";
    private static final String CATEGORY_EQUALS = "CATEGORY=";

    public String[] kindsHandled() {
        return new String[]{"ability", "feat"};
    }

    public Prerequisite parse(String kind, String formula, boolean invertResult, boolean overrideQualify) throws PersistenceLayerException {
        if ("feat".equalsIgnoreCase(kind)) {
            Logging.deprecationPrint((String)"PREFEAT has been deprecated, please use PREABILITY");
        }
        boolean extract = "ability".equalsIgnoreCase(kind);
        kind = "ability";
        Prerequisite prereq = super.parse(kind, formula, invertResult, overrideQualify);
        prereq.setOriginalCheckmult(formula.indexOf(",CHECKMULT,") != -1);
        if (extract) {
            this.extractCategory(prereq);
        } else {
            this.setCategory(prereq, "FEAT");
        }
        if (formula.indexOf(91) >= 0) {
            this.negateAbilityChoice(prereq);
        }
        this.convertKeysToSubKeys(prereq, "ability");
        prereq.setOverrideQualify(overrideQualify);
        return prereq;
    }

    private void setCategory(Prerequisite prereq, String string) {
        prereq.setCategoryName(string);
        for (Prerequisite element : prereq.getPrerequisites()) {
            this.setCategory(element, string);
        }
    }

    private void extractCategory(Prerequisite prereq) throws PersistenceLayerException {
        String preKey;
        String categoryName = "";
        if (prereq.getPrerequisiteCount() == 0 && ((preKey = prereq.getKey()).toUpperCase().startsWith(CATEGORY) || preKey.toUpperCase().startsWith(CATEGORY_EQUALS))) {
            String tempCat = preKey.substring(CATEGORY.length());
            if (tempCat.toUpperCase().trim().equals("ANY")) {
                Logging.errorPrint((String)"ANY no longer allowed as an Ability Category in PREABILITY");
            } else {
                categoryName = tempCat;
            }
            prereq.setKey("ANY");
            prereq.setCategoryName(categoryName);
        }
        ArrayList prereqList = new ArrayList(prereq.getPrerequisites());
        for (Prerequisite p : prereqList) {
            if (p.getKind() == null) {
                this.extractCategory(p);
                continue;
            }
            String preKey2 = p.getKey();
            if (!preKey2.toUpperCase().startsWith(CATEGORY) && !preKey2.toUpperCase().startsWith(CATEGORY_EQUALS)) continue;
            String tempCat = preKey2.substring(CATEGORY.length());
            if (categoryName.length() > 0) {
                throw new PersistenceLayerException(LanguageBundle.getFormattedString((String)"Errors.PreAbility.MultipleCategory", (Object[])new Object[]{categoryName, tempCat}));
            }
            if (p != prereqList.get(0)) {
                throw new PersistenceLayerException(LanguageBundle.getFormattedString((String)"Errors.PreAbility.CategoryNotFirst", (Object[])new Object[]{tempCat}));
            }
            if (tempCat.toUpperCase().trim().equals("ANY")) {
                Logging.errorPrint((String)"ANY no longer allowed as an Ability Category in PREABILITY");
            } else {
                categoryName = tempCat;
            }
            prereq.removePrerequisite(p);
        }
        if (categoryName.length() > 0) {
            for (Prerequisite p : prereq.getPrerequisites()) {
                p.setCategoryName(categoryName);
            }
        } else {
            String preKey3;
            if (prereq.getPrerequisiteCount() == 0) {
                preKey3 = prereq.getKey();
            } else {
                StringBuilder sb = new StringBuilder();
                for (Prerequisite p : prereq.getPrerequisites()) {
                    sb.append(p.getKey()).append(',');
                }
                sb.setLength(sb.length() - 1);
                preKey3 = sb.toString();
            }
            Logging.errorPrint((String)("PREABILITY: found without CATEGORY: " + preKey3));
        }
    }

    private void negateAbilityChoice(Prerequisite prereq) {
        int modified = 0;
        for (Prerequisite p : prereq.getPrerequisites()) {
            if (p.getKind() == null) {
                this.negateAbilityChoice(p);
                continue;
            }
            String preKey = p.getKey();
            if (!preKey.startsWith("[") || !preKey.endsWith("]")) continue;
            preKey = preKey.substring(1, preKey.length() - 1);
            p.setKey(preKey);
            p.setOperator(p.getOperator().invert());
            ++modified;
        }
        if (modified > 0) {
            String oper = prereq.getOperand();
            try {
                oper = Integer.toString(Integer.parseInt(oper) + modified);
            }
            catch (NumberFormatException nfe) {
                oper = "(" + oper + ")+" + Integer.toString(modified);
            }
            prereq.setOperand(oper);
        }
    }

    protected boolean allowsNegate() {
        return true;
    }
}

