/*
 * Decompiled with CFR 0.152.
 */
package plugin.exporttokens;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.Vision;
import pcgen.core.display.CharacterDisplay;
import pcgen.io.ExportHandler;
import pcgen.io.exporttoken.AbstractExportToken;

public class VisionToken
extends AbstractExportToken {
    public String getTokenName() {
        return "VISION";
    }

    public String getToken(String tokenSource, CharacterDisplay display, ExportHandler eh) {
        StringTokenizer aTok = new StringTokenizer(tokenSource, ".");
        aTok.nextToken();
        ArrayList visionList = new ArrayList(display.getVisionList());
        int visionIndex = 0;
        int startIndex = 0;
        if (aTok.hasMoreTokens()) {
            try {
                startIndex = Integer.parseInt(aTok.nextToken());
                visionIndex = startIndex + 1;
            }
            catch (NumberFormatException e) {}
        } else {
            visionIndex = visionList.size();
        }
        if (visionList.isEmpty() || startIndex >= visionList.size()) {
            return "";
        }
        List subList = visionList.subList(Math.max(startIndex, 0), Math.min(visionIndex, visionList.size()));
        StringBuilder result = new StringBuilder();
        for (Vision vision : subList) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(vision.getType());
            String distStr = vision.getDistance().toString();
            int dist = 0;
            if (distStr != null && distStr.trim().length() > 0) {
                dist = Integer.parseInt(distStr);
            }
            if (dist <= 0) continue;
            result.append(" (");
            result.append(Globals.getGameModeUnitSet().displayDistanceInUnitSet((double)dist));
            result.append(Globals.getGameModeUnitSet().getDistanceUnit());
            result.append(")");
        }
        return result.toString();
    }
}

