/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.debug;

import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;

public class ScriptBreakPoint
implements Releasable {
    private static final String CONDITION = "condition";
    private static final String LINE = "line";
    private static final String NUMBER = "number";
    private static final String SET_CONDITION = "setCondition";
    private V8Object v8Object;

    ScriptBreakPoint(V8Object v8Object) {
        this.v8Object = v8Object.twin();
    }

    public int getBreakPointNumber() {
        return this.v8Object.executeIntegerFunction(NUMBER, null);
    }

    public int getLine() {
        return this.v8Object.executeIntegerFunction(LINE, null);
    }

    public void setCondition(String condition) {
        V8Array parameters = new V8Array(this.v8Object.getRuntime());
        parameters.push(condition);
        try {
            this.v8Object.executeVoidFunction(SET_CONDITION, parameters);
        }
        finally {
            parameters.release();
        }
    }

    public String getCondition() {
        try {
            return this.v8Object.executeStringFunction(CONDITION, null);
        }
        catch (V8ResultUndefined e) {
            return "undefined";
        }
    }

    @Override
    public void release() {
        if (this.v8Object != null && !this.v8Object.isReleased()) {
            this.v8Object.release();
            this.v8Object = null;
        }
    }
}

