/*
 * Decompiled with CFR 0.152.
 */
package coursier.util.shaded.org.jsoup.nodes;

import coursier.util.shaded.org.jsoup.helper.Validate;
import coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursier.util.shaded.org.jsoup.nodes.Document;
import coursier.util.shaded.org.jsoup.nodes.LeafNode;
import java.io.IOException;
import org.jspecify.annotations.Nullable;

public class DocumentType
extends LeafNode {
    public static final String PUBLIC_KEY = "PUBLIC";
    public static final String SYSTEM_KEY = "SYSTEM";
    private static final String Name = "#doctype";
    private static final String PubSysKey = "pubSysKey";
    private static final String PublicId = "publicId";
    private static final String SystemId = "systemId";

    public DocumentType(String name, String publicId, String systemId) {
        super(name);
        Validate.notNull(publicId);
        Validate.notNull(systemId);
        this.attr(Name, name);
        this.attr(PublicId, publicId);
        this.attr(SystemId, systemId);
        this.updatePubSyskey();
    }

    public void setPubSysKey(@Nullable String value) {
        if (value != null) {
            this.attr(PubSysKey, value);
        }
    }

    private void updatePubSyskey() {
        if (this.has(PublicId)) {
            this.attr(PubSysKey, PUBLIC_KEY);
        } else if (this.has(SystemId)) {
            this.attr(PubSysKey, SYSTEM_KEY);
        }
    }

    public String name() {
        return this.attr(Name);
    }

    public String publicId() {
        return this.attr(PublicId);
    }

    public String systemId() {
        return this.attr(SystemId);
    }

    @Override
    public String nodeName() {
        return Name;
    }

    @Override
    void outerHtmlHead(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        if (this.siblingIndex > 0 && out.prettyPrint()) {
            accum2.append('\n');
        }
        if (out.syntax() == Document.OutputSettings.Syntax.html && !this.has(PublicId) && !this.has(SystemId)) {
            accum2.append("<!doctype");
        } else {
            accum2.append("<!DOCTYPE");
        }
        if (this.has(Name)) {
            accum2.append(" ").append(this.attr(Name));
        }
        if (this.has(PubSysKey)) {
            accum2.append(" ").append(this.attr(PubSysKey));
        }
        if (this.has(PublicId)) {
            accum2.append(" \"").append(this.attr(PublicId)).append('\"');
        }
        if (this.has(SystemId)) {
            accum2.append(" \"").append(this.attr(SystemId)).append('\"');
        }
        accum2.append('>');
    }

    @Override
    void outerHtmlTail(Appendable accum2, int depth, Document.OutputSettings out) {
    }

    private boolean has(String attribute) {
        return !StringUtil.isBlank(this.attr(attribute));
    }
}

