/*
 * Decompiled with CFR 0.152.
 */
package coursierapi;

import coursierapi.DependencyManagement;
import coursierapi.Module;
import coursierapi.Publication;
import coursierapi.ScalaVersion;
import coursierapi.shaded.coursier.internal.api.ApiHelper;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class Dependency
implements Serializable {
    private Module module;
    private String version;
    private final Set<Map.Entry<String, String>> exclusions;
    private String configuration;
    private Publication publication;
    private boolean transitive;
    private final HashMap<DependencyManagement.Key, DependencyManagement.Values> overrides;

    private Dependency(Module module, String string) {
        this.module = module;
        this.version = string;
        this.exclusions = new HashSet<Map.Entry<String, String>>();
        this.configuration = "";
        this.publication = null;
        this.transitive = true;
        this.overrides = new HashMap();
    }

    public static Dependency of(Module module, String string) {
        return new Dependency(module, string);
    }

    public static Dependency of(String string, String string2, String string3) {
        return new Dependency(Module.of(string, string2), string3);
    }

    public static Dependency of(Dependency dependency) {
        return new Dependency(dependency.getModule(), dependency.getVersion()).withExclusion(dependency.getExclusions()).withConfiguration(dependency.getConfiguration()).withType(dependency.getType()).withClassifier(dependency.getClassifier()).withPublication(dependency.getPublication()).withTransitive(dependency.isTransitive()).withOverrides(dependency.getOverrides());
    }

    public static Dependency parse(String string, ScalaVersion scalaVersion) {
        return ApiHelper.parseDependency(string, scalaVersion.getVersion());
    }

    public Dependency withModule(Module module) {
        this.module = module;
        return this;
    }

    public Dependency withVersion(String string) {
        this.version = string;
        return this;
    }

    public Dependency addExclusion(String string, String string2) {
        this.exclusions.add(new AbstractMap.SimpleImmutableEntry<String, String>(string, string2));
        return this;
    }

    public Dependency withExclusion(Set<Map.Entry<String, String>> set) {
        this.exclusions.clear();
        this.exclusions.addAll(set);
        return this;
    }

    public Dependency withConfiguration(String string) {
        this.configuration = string;
        return this;
    }

    public Dependency withType(String string) {
        this.publication = this.publication == null ? new Publication("", string, "", "") : this.publication.withType(string);
        if (this.publication.isEmpty()) {
            this.publication = null;
        }
        return this;
    }

    public Dependency withClassifier(String string) {
        this.publication = this.publication == null ? new Publication("", "", "", string) : this.publication.withClassifier(string);
        if (this.publication.isEmpty()) {
            this.publication = null;
        }
        return this;
    }

    public Dependency withPublication(Publication publication) {
        this.publication = publication;
        return this;
    }

    public Dependency withTransitive(boolean bl) {
        this.transitive = bl;
        return this;
    }

    public Dependency addOverride(DependencyManagement.Key key2, DependencyManagement.Values values2) {
        this.overrides.put(key2, values2);
        return this;
    }

    public Dependency addOverride(String string, String string2, String string3) {
        this.overrides.put(new DependencyManagement.Key(string, string2, "", ""), new DependencyManagement.Values("", string3, false));
        return this;
    }

    public Dependency withOverrides(Map<DependencyManagement.Key, DependencyManagement.Values> map) {
        this.overrides.clear();
        this.overrides.putAll(map);
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Dependency)) {
            return false;
        }
        Dependency dependency = (Dependency)object;
        return this.transitive == dependency.transitive && Objects.equals(this.module, dependency.module) && Objects.equals(this.version, dependency.version) && Objects.equals(this.exclusions, dependency.exclusions) && Objects.equals(this.configuration, dependency.configuration) && Objects.equals(this.publication, dependency.publication) && Objects.equals(this.overrides, dependency.overrides);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.version, this.exclusions, this.configuration, this.publication, this.transitive, this.overrides);
    }

    public String toString() {
        return "Dependency{module=" + this.module + ", version='" + this.version + '\'' + ", exclusions=" + this.exclusions + ", configuration='" + this.configuration + '\'' + ", publication=" + this.publication + ", transitive=" + this.transitive + ", overrides=" + this.overrides + '}';
    }

    public Module getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.version;
    }

    public Set<Map.Entry<String, String>> getExclusions() {
        return Collections.unmodifiableSet(this.exclusions);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getType() {
        if (this.publication == null) {
            return "";
        }
        return this.publication.getType();
    }

    public String getClassifier() {
        if (this.publication == null) {
            return "";
        }
        return this.publication.getClassifier();
    }

    public Publication getPublication() {
        return this.publication;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public Map<DependencyManagement.Key, DependencyManagement.Values> getOverrides() {
        return Collections.unmodifiableMap(this.overrides);
    }
}

