/*
 * Decompiled with CFR 0.152.
 */
package mill.runner;

import geny.Writable;
import geny.Writable$;
import io.github.alexarchambault.windowsansi.WindowsAnsi;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Date;
import java.util.Locale;
import mill.api.MillException;
import mill.api.SystemStreams;
import mill.api.SystemStreams$;
import mill.api.WorkspaceRoot$;
import mill.bsp.BspContext;
import mill.bsp.BspContext$;
import mill.bsp.BspServerResult;
import mill.bsp.BspServerResult$ReloadWorkspace$;
import mill.main.BuildInfo$;
import mill.main.client.OutFiles;
import mill.main.client.Util;
import mill.main.client.lock.Lock;
import mill.main.client.lock.Locked;
import mill.main.client.lock.TryLocked;
import mill.moduledefs.Scaladoc;
import mill.runner.MillBuildBootstrap;
import mill.runner.MillCliConfig;
import mill.runner.MillCliConfigParser$;
import mill.runner.MillMain$;
import mill.runner.RunnerState;
import mill.runner.RunnerState$;
import mill.runner.TailManager;
import mill.runner.TeePrintStream;
import mill.runner.Watching;
import mill.runner.Watching$;
import mill.util.ColorLogger;
import mill.util.Colors;
import mill.util.Colors$BlackWhite$;
import mill.util.Colors$Default$;
import mill.util.PrintLogger;
import mill.util.PromptLogger;
import mill.util.PromptLogger$;
import mill.util.Util$;
import os.Path;
import os.Path$;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible$StringConvertible$;
import os.RelPath$;
import os.Source$;
import os.SubProcess$;
import os.exists$;
import os.makeDir$all$;
import os.read$;
import os.read$lines$;
import os.remove$;
import os.remove$all$;
import os.write$over$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.SystemProperties;
import scala.util.Either;
import scala.util.Left;
import scala.util.Properties$;
import scala.util.Right;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;
import scala.util.control.NonFatal$;

public final class MillMain$ {
    public static final MillMain$ MODULE$ = new MillMain$();

    public <T> PartialFunction<Throwable, Tuple2<Object, T>> handleMillException(PrintStream err, Function0<T> onError2) {
        return new Serializable(err, onError2){
            private static final long serialVersionUID = 0L;
            private final PrintStream err$1;
            private final Function0 onError$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                InvocationTargetException invocationTargetException;
                A1 A12 = x1;
                if (A12 instanceof MillException) {
                    MillException millException = (MillException)A12;
                    this.err$1.println(millException.getMessage());
                    return (B1)new Tuple2<Boolean, R>(BoxesRunTime.boxToBoolean(false), this.onError$1.apply());
                }
                if (A12 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)A12).getCause() != null && invocationTargetException.getCause() instanceof MillException) {
                    this.err$1.println(invocationTargetException.getCause().getMessage());
                    return (B1)new Tuple2<Boolean, R>(BoxesRunTime.boxToBoolean(false), this.onError$1.apply());
                }
                if (A12 != null && NonFatal$.MODULE$.apply(A1 = A12)) {
                    this.err$1.println(new StringBuilder(30).append("An unexpected error occurred ").append(A1).append("\n").append(Predef$.MODULE$.wrapRefArray((Object[])A1.getStackTrace()).mkString("\n")).toString());
                    throw A1;
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable;
                InvocationTargetException invocationTargetException;
                Throwable throwable2 = x1;
                if (throwable2 instanceof MillException) {
                    return true;
                }
                if (throwable2 instanceof InvocationTargetException && (invocationTargetException = (InvocationTargetException)throwable2).getCause() != null && invocationTargetException.getCause() instanceof MillException) {
                    return true;
                }
                return throwable2 != null && NonFatal$.MODULE$.apply(throwable = throwable2);
            }
            {
                this.err$1 = err$1;
                this.onError$1 = onError$1;
            }
        };
    }

    public void main(String[] args) {
        SystemStreams$.MODULE$.withTopLevelSystemStreamProxy(() -> {
            Tuple3<SystemStreams, $colon$colon<Nothing$>, Some<PrintStream>> tuple3;
            Tuple3<SystemStreams, $colon$colon<Nothing$>, Some<PrintStream>> tuple32;
            SystemStreams initialSystemStreams = SystemStreams$.MODULE$.original();
            Option option = ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps(args));
            Option<String> option2 = Option$.MODULE$.apply("--bsp");
            if (!(option != null ? !option.equals(option2) : option2 != null)) {
                Path stderrFile = WorkspaceRoot$.MODULE$.workspaceRoot().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{".bsp", "mill-bsp.stderr"}))));
                makeDir$all$.MODULE$.apply(stderrFile.$div(PathChunk$.MODULE$.RelPathChunk(os.package$.MODULE$.up())));
                PrintStream errFile = new PrintStream(Files.newOutputStream(stderrFile.toNIO(), StandardOpenOption.APPEND));
                TeePrintStream errTee = new TeePrintStream(initialSystemStreams.err(), errFile);
                String msg = new StringBuilder(28).append("Mill in BSP mode, version ").append(BuildInfo$.MODULE$.millVersion()).append(", ").append(new Date()).toString();
                errTee.println(msg);
                tuple32 = new Tuple3<SystemStreams, $colon$colon<Nothing$>, Some<PrintStream>>(new SystemStreams(initialSystemStreams.out(), errTee, System.in), new $colon$colon<Nothing$>((Nothing$)((Object)errFile), Nil$.MODULE$), new Some<PrintStream>(errFile));
            } else {
                tuple32 = tuple3 = new Tuple3<SystemStreams, $colon$colon<Nothing$>, Some<PrintStream>>(initialSystemStreams, ($colon$colon<Nothing$>)((Object)Nil$.MODULE$), (Some<PrintStream>)((Object)None$.MODULE$));
            }
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            SystemStreams runnerStreams = tuple3._1();
            Seq cleanupStreams = tuple3._2();
            Option bspLog = tuple3._3();
            Tuple3<SystemStreams, Seq, Option> tuple33 = new Tuple3<SystemStreams, Seq, Option>(runnerStreams, cleanupStreams, bspLog);
            SystemStreams runnerStreams2 = tuple33._1();
            Seq cleanupStreams2 = tuple33._2();
            Option bspLog2 = tuple33._3();
            Serializable serializable = Properties$.MODULE$.isWin() && Util.hasConsole() ? BoxesRunTime.boxToBoolean(WindowsAnsi.setup()) : BoxedUnit.UNIT;
            Tuple2 tuple2 = MillMain$.liftedTree1$1(args, runnerStreams2, bspLog2, cleanupStreams2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean result2 = tuple2._1$mcZ$sp();
            boolean result3 = result2;
            System.exit(result3 ? 0 : 1);
        });
    }

    public Tuple2<Object, RunnerState> main0(String[] args, RunnerState stateCache, boolean mainInteractive, SystemStreams streams0, Option<PrintStream> bspLog, Map<String, String> env, Function1<Object, BoxedUnit> setIdle, Map<String, String> userSpecifiedProperties0, Map<String, String> initialSystemProperties, Function1<Object, Nothing$> systemExit, Path serverDir) {
        PrintLogger.State printLoggerState = new PrintLogger.State();
        SystemStreams streams = streams0;
        return (Tuple2)SystemStreams$.MODULE$.withStreams(streams, (Function0<Tuple2> & Serializable)() -> (Tuple2)SubProcess$.MODULE$.env().withValue(env, (Function0<Tuple2> & Serializable)() -> {
            MillCliConfig config;
            MillCliConfig config2;
            MillCliConfig config3;
            boolean bl = false;
            Right right = null;
            Either<String, MillCliConfig> either = MillCliConfigParser$.MODULE$.parse(args);
            if (either instanceof Left) {
                Left left = (Left)either;
                String msg = (String)left.value();
                streams.err().println(msg);
                return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), RunnerState$.MODULE$.empty());
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                MillCliConfig config4 = (MillCliConfig)right.value();
                if (config4.help().value()) {
                    streams.out().println(MillCliConfigParser$.MODULE$.longUsageText());
                    return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(true), RunnerState$.MODULE$.empty());
                }
            }
            if (bl && (config3 = (MillCliConfig)right.value()).showVersion().value()) {
                String javaVersion = MillMain$.prop$1("java.version");
                String javaVendor = MillMain$.prop$1("java.vendor");
                String javaHome = MillMain$.prop$1("java.home");
                String fileEncoding = MillMain$.prop$1("file.encoding");
                String osName = MillMain$.prop$1("os.name");
                String osVersion = MillMain$.prop$1("os.version");
                String osArch = MillMain$.prop$1("os.arch");
                streams.out().println(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(183).append("Mill Build Tool version ").append(BuildInfo$.MODULE$.millVersion()).append("\n                 |Java version: ").append(javaVersion).append(", vendor: ").append(javaVendor).append(", runtime: ").append(javaHome).append("\n                 |Default locale: ").append(Locale.getDefault()).append(", platform encoding: ").append(fileEncoding).append("\n                 |OS name: \"").append(osName).append("\", version: ").append(osVersion).append(", arch: ").append(osArch).toString())));
                return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(true), RunnerState$.MODULE$.empty());
            }
            if (bl && ((config2 = (MillCliConfig)right.value()).interactive().value() || config2.noServer().value() || config2.bsp().value())) {
                Class<?> clazz = streams.in().getClass();
                Class<PipedInputStream> clazz2 = PipedInputStream.class;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    streams.err().println("-i/--interactive/--no-server/--bsp must be passed in as the first argument");
                    return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), RunnerState$.MODULE$.empty());
                }
            }
            if (bl) {
                MillCliConfig config5 = (MillCliConfig)right.value();
                if (package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{config5.interactive().value(), config5.noServer().value(), config5.bsp().value()})).count((Function1<Object, Object> & Serializable)x -> BoxesRunTime.boxToBoolean(MillMain$.$anonfun$main0$3(BoxesRunTime.unboxToBoolean(x)))) > 1) {
                    streams.err().println("Only one of -i/--interactive, --no-server or --bsp may be given");
                    return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), RunnerState$.MODULE$.empty());
                }
            }
            if (bl && (config = (MillCliConfig)right.value()).metaLevel().exists(x$3 -> x$3 < 0)) {
                streams.err().println("--meta-level cannot be negative");
                return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), RunnerState$.MODULE$.empty());
            }
            if (bl) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Colors colors;
                MillCliConfig config6 = (MillCliConfig)right.value();
                boolean noColorViaEnv = env.get("NO_COLOR").exists((Function1<String, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$4))));
                boolean colored = BoxesRunTime.unboxToBoolean(config6.color().getOrElse(() -> mainInteractive && !noColorViaEnv));
                Colors colors2 = colors = colored ? Colors$Default$.MODULE$ : Colors$BlackWhite$.MODULE$;
                if (!config6.silent().value()) {
                    MODULE$.checkMillVersionFromFile(WorkspaceRoot$.MODULE$.workspaceRoot(), streams.err());
                }
                boolean bspMode = config6.bsp().value() && config6.leftoverArgs().value().isEmpty();
                Either<String, Object> maybeThreadCount = MODULE$.parseThreadCount(config6.threadCountRaw(), Runtime.getRuntime().availableProcessors());
                if (config6.disableTicker().value()) {
                    streams.err().println("--disable-ticker will be removed in Mill 0.13.0, use `--ticker false`");
                }
                config6.enableTicker().foreach((Function1<Object, Object> & Serializable)value -> {
                    MillMain$.$anonfun$main0$7(streams, BoxesRunTime.unboxToBoolean(value));
                    return BoxedUnit.UNIT;
                });
                if (config6.repl().value()) {
                    streams.err().println("The --repl mode is no longer supported.");
                    tuple22 = new Tuple2(BoxesRunTime.boxToBoolean(false), stateCache);
                } else if (!bspMode && config6.leftoverArgs().value().isEmpty()) {
                    Predef$.MODULE$.println(MillCliConfigParser$.MODULE$.shortUsageText());
                    tuple22 = new Tuple2(BoxesRunTime.boxToBoolean(true), stateCache);
                } else if (maybeThreadCount.isLeft()) {
                    streams.err().println(maybeThreadCount.swap().toOption().get());
                    tuple22 = new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), stateCache);
                } else {
                    Map userSpecifiedProperties = (Map)userSpecifiedProperties0.$plus$plus(config6.extraSystemProperties());
                    Some<Object> threadCount = new Some<Object>(maybeThreadCount.toOption().get());
                    Option bspContext = bspMode ? new Some<BspContext>(new BspContext(streams, bspLog, config6.home())) : None$.MODULE$;
                    String bspCmd = "mill.bsp.BSP/startSession";
                    Seq targetsAndParams = (Seq)bspContext.map((Function1<BspContext, Seq> & Serializable)x$5 -> new $colon$colon<Nothing$>((Nothing$)((Object)bspCmd), Nil$.MODULE$)).getOrElse((Function0<List> & Serializable)() -> config6.leftoverArgs().value().toList());
                    Path out = Path$.MODULE$.apply(OutFiles.out, WorkspaceRoot$.MODULE$.workspaceRoot(), PathConvertible$StringConvertible$.MODULE$);
                    BooleanRef repeatForBsp = BooleanRef.create(true);
                    ObjectRef<Tuple2<Boolean, RunnerState>> loopRes = ObjectRef.create(new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(false), RunnerState$.MODULE$.empty()));
                    while (repeatForBsp.elem) {
                        repeatForBsp.elem = false;
                        Using$.MODULE$.resource(new TailManager(serverDir), (Function1<TailManager, Object> & Serializable)tailManager -> {
                            MillMain$.$anonfun$main0$10(config6, out, streams, setIdle, userSpecifiedProperties, initialSystemProperties, bspContext, targetsAndParams, mainInteractive, printLoggerState, serverDir, colored, colors, env, threadCount, stateCache, systemExit, streams0, repeatForBsp, bspCmd, loopRes, tailManager);
                            return BoxedUnit.UNIT;
                        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
                    }
                    bspContext.foreach((Function1<BspContext, Object> & Serializable)ctx -> {
                        MillMain$.$anonfun$main0$21(streams, ctx);
                        return BoxedUnit.UNIT;
                    });
                    tuple22 = tuple2 = (Tuple2)loopRes.elem;
                }
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                boolean success = tuple2._1$mcZ$sp();
                RunnerState nextStateCache = tuple2._2();
                Tuple2<Boolean, RunnerState> tuple23 = new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(success), nextStateCache);
                boolean success2 = tuple23._1$mcZ$sp();
                RunnerState nextStateCache2 = tuple23._2();
                if (config6.ringBell().value()) {
                    if (success2) {
                        Predef$.MODULE$.println("\u0007");
                    } else {
                        Predef$.MODULE$.println("\u0007");
                        Thread.sleep(250L);
                        Predef$.MODULE$.println("\u0007");
                    }
                }
                return new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(success2), nextStateCache2);
            }
            throw new MatchError(either);
        }));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Either<String, Object> parseThreadCount(Option<String> threadCountRaw, int availableCores) {
        Option<Seq<String>> option;
        String string;
        Option<Seq<String>> option2;
        String string2;
        Right right;
        boolean bl = false;
        Some some = null;
        Option<String> option3 = threadCountRaw;
        if (None$.MODULE$.equals(option3)) {
            right = new Right(BoxesRunTime.boxToInteger(availableCores));
            return right.map(x -> {
                if (x < 1) {
                    return 1;
                }
                return x;
            });
        }
        if (option3 instanceof Some) {
            bl = true;
            some = (Some)option3;
            String string3 = (String)some.value();
            if ("0".equals(string3)) {
                right = new Right(BoxesRunTime.boxToInteger(availableCores));
                return right.map(x -> {
                    if (x < 1) {
                        return 1;
                    }
                    return x;
                });
            }
        }
        if (bl && (string2 = (String)some.value()) != null && !(option2 = new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "C"})).s().unapplySeq(string2)).isEmpty() && option2.get() != null && ((SeqOps)option2.get()).lengthCompare(1) == 0) {
            String n = (String)((SeqOps)option2.get()).apply(0);
            right = StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(n)).toRight((Function0<String> & Serializable)() -> MillMain$.err$2("Failed to find a float number before \"C\".", threadCountRaw)).map(m -> (int)(m * (double)availableCores));
            return right.map(x -> {
                if (x < 1) {
                    return 1;
                }
                return x;
            });
        }
        if (bl && (string = (String)some.value()) != null && !(option = new StringContext(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"C-", ""})).s().unapplySeq(string)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(1) == 0) {
            String n = (String)((SeqOps)option.get()).apply(0);
            right = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(n)).toRight((Function0<String> & Serializable)() -> MillMain$.err$2("Failed to find a int number after \"C-\".", threadCountRaw)).map(x$8 -> availableCores - x$8);
            return right.map(x -> {
                if (x < 1) {
                    return 1;
                }
                return x;
            });
        }
        if (!bl) throw new MatchError(option3);
        String n = (String)some.value();
        right = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(n)).toRight((Function0<String> & Serializable)() -> MillMain$.err$2("Failed to find a int number", threadCountRaw));
        return right.map(x -> {
            if (x < 1) {
                return 1;
            }
            return x;
        });
    }

    public ColorLogger getLogger(SystemStreams streams, MillCliConfig config, boolean mainInteractive, Option<Object> enableTicker, PrintLogger.State printLoggerState, Path serverDir, boolean colored, Colors colors) {
        ColorLogger logger = config.disablePrompt().value() ? new PrintLogger(colored, BoxesRunTime.unboxToBoolean(enableTicker.getOrElse(() -> mainInteractive)), colors.info(), colors.error(), streams, config.debugLog().value(), "", printLoggerState) : new PromptLogger(colored, BoxesRunTime.unboxToBoolean(enableTicker.getOrElse(() -> true)), colors.info(), colors.error(), streams, config.debugLog().value(), config.leftoverArgs().value().mkString(" "), serverDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"terminfo"})))), () -> System.currentTimeMillis(), PromptLogger$.MODULE$.$lessinit$greater$default$10());
        return logger;
    }

    @Scaladoc(value="/**\n   * Determine, whether we need a `build.mill` or not.\n   */")
    private boolean needBuildFile(MillCliConfig config) {
        $colon$colon<Nothing$> noBuildFileTaskWhitelist = new $colon$colon<Nothing$>((Nothing$)((Object)"init"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"version"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"mill.scalalib.giter8.Giter8Module/init"), Nil$.MODULE$)));
        Seq<String> targetsAndParams = config.leftoverArgs().value();
        boolean whitelistMatch = targetsAndParams.nonEmpty() && noBuildFileTaskWhitelist.exists((Function1<String, Object> & Serializable)x$9 -> BoxesRunTime.boxToBoolean(MillMain$.$anonfun$needBuildFile$1(targetsAndParams, x$9)));
        boolean extraPlugins = config.imports().nonEmpty();
        return !whitelistMatch && !extraPlugins;
    }

    public void checkMillVersionFromFile(Path projectDir, PrintStream stderr) {
        new $colon$colon<Nothing$>((Nothing$)((Object)projectDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{".config", "mill-version"}))))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)projectDir.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{".mill-version"}))))), Nil$.MODULE$)).collectFirst(new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (exists$.MODULE$.apply(A1)) {
                    return (B1)new Tuple2<A1, Option<A>>(A1, read$lines$.MODULE$.apply(A1).find((Function1<String, Object> & Serializable)l -> BoxesRunTime.boxToBoolean(anonfun.checkMillVersionFromFile.1.$anonfun$applyOrElse$1(l))));
                }
                return function1.apply(x1);
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                return exists$.MODULE$.apply(path);
            }

            public static final /* synthetic */ boolean $anonfun$applyOrElse$1(String l) {
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(l.trim()));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.String )}, serializedLambda);
            }
        }).foreach((Function1<Tuple2, Object> & Serializable)x0$1 -> {
            MillMain$.$anonfun$checkMillVersionFromFile$2(stderr, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void adjustJvmProperties(Map<String, String> userSpecifiedProperties, Map<String, String> initialSystemProperties) {
        SystemProperties currentProps = scala.sys.package$.MODULE$.props();
        Map desiredProps = (Map)initialSystemProperties.$plus$plus(userSpecifiedProperties);
        Set systemPropertiesToUnset = (Set)currentProps.keySet().$minus$minus(desiredProps.keySet());
        systemPropertiesToUnset.foreach((Function1<String, String> & Serializable)k -> System.clearProperty(k));
        desiredProps.withFilter((Function1<Tuple2, Object> & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean(MillMain$.$anonfun$adjustJvmProperties$2(check$ifrefutable$1))).foreach((Function1<Tuple2, String> & Serializable)x$10 -> {
            Tuple2 tuple2 = x$10;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return System.setProperty(k, v);
            }
            throw new MatchError(tuple2);
        });
    }

    public <T> T withOutLock(boolean noBuildLock, boolean noWaitForBuildLock, Path out, Seq<String> targetsAndParams, SystemStreams streams, Function0<T> t) {
        Locked locked;
        if (noBuildLock) {
            return t.apply();
        }
        Lock outLock = Lock.file(out.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-lock"})))).toString());
        TryLocked tryLocked = outLock.tryLock();
        if (tryLocked.isLocked()) {
            locked = tryLocked;
        } else {
            if (noWaitForBuildLock) {
                throw new Exception(new StringBuilder(8).append(MillMain$.activeTaskPrefix$1(out)).append(" failing").toString());
            }
            streams.err().println(new StringBuilder(29).append(MillMain$.activeTaskPrefix$1(out)).append(" waiting for it to be done...").toString());
            locked = outLock.lock();
        }
        return (T)Using$.MODULE$.resource(locked, (Function1<Locked, Object> & Serializable)x$11 -> {
            Object r;
            write$over$.MODULE$.apply(out.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-active-command"})))), Source$.MODULE$.WritableSource(targetsAndParams.mkString(" "), (Function1<String, Writable.StringWritable> & Serializable)s -> Writable$.MODULE$.StringWritable((String)s)), write$over$.MODULE$.apply$default$3(), write$over$.MODULE$.apply$default$4(), write$over$.MODULE$.apply$default$5(), write$over$.MODULE$.apply$default$6());
            try {
                r = t.apply();
            }
            catch (Throwable throwable) {
                remove$all$.MODULE$.apply(out.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-active-command"})))));
                throw throwable;
            }
            remove$all$.MODULE$.apply(out.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-active-command"})))));
            return r;
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$main$2(boolean b) {
    }

    private static final /* synthetic */ Tuple2 liftedTree1$1(String[] args$1, SystemStreams runnerStreams$1, Option bspLog$1, Seq cleanupStreams$1) {
        Tuple2<Object, RunnerState> tuple2;
        block6: {
            try {
                try {
                    tuple2 = MODULE$.main0((String[])ArrayOps$.MODULE$.tail$extension(Predef$.MODULE$.refArrayOps(args$1)), RunnerState$.MODULE$.empty(), Util$.MODULE$.isInteractive(), runnerStreams$1, bspLog$1, CollectionConverters$.MODULE$.MapHasAsScala(System.getenv()).asScala().toMap($less$colon$less$.MODULE$.refl()), (Function1<Object, BoxedUnit>)(Function1<Object, Object> & Serializable)b -> {
                        MillMain$.$anonfun$main$2(BoxesRunTime.unboxToBoolean(b));
                        return BoxedUnit.UNIT;
                    }, (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), scala.sys.package$.MODULE$.props().toMap($less$colon$less$.MODULE$.refl()), (Function1<Object, Nothing$> & Serializable)i -> scala.sys.package$.MODULE$.exit(BoxesRunTime.unboxToInt(i)), Path$.MODULE$.apply(ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps(args$1)), PathConvertible$StringConvertible$.MODULE$));
                }
                catch (Throwable x$23) {
                    PartialFunction<Throwable, Tuple2<Object, Object>> catchExpr$1 = MODULE$.handleMillException(runnerStreams$1.err(), () -> {});
                    if (catchExpr$1.isDefinedAt(x$23)) {
                        tuple2 = (Tuple2<Object, RunnerState>)catchExpr$1.apply(x$23);
                        break block6;
                    }
                    throw x$23;
                }
            }
            finally {
                cleanupStreams$1.foreach((Function1<PrintStream, Object> & Serializable)x$2 -> {
                    x$2.close();
                    return BoxedUnit.UNIT;
                });
            }
        }
        return tuple2;
    }

    private static final String prop$1(String k) {
        return System.getProperty(k, new StringBuilder(10).append("<unknown ").append(k).append(">").toString());
    }

    public static final /* synthetic */ boolean $anonfun$main0$3(boolean x) {
        return BoxesRunTime.unboxToBoolean(Predef$.MODULE$.identity(BoxesRunTime.boxToBoolean(x)));
    }

    public static final /* synthetic */ void $anonfun$main0$7(SystemStreams streams$1, boolean value) {
        streams$1.err().println(new StringBuilder(63).append("--enable-ticker will be removed in Mill 0.13.0, use `--ticker ").append(value).append("`").toString());
    }

    public static final /* synthetic */ Watching.Result $anonfun$main0$11(Map userSpecifiedProperties$1, Map initialSystemProperties$1, MillCliConfig config$1, Option bspContext$1, Path out$1, Seq targetsAndParams$1, SystemStreams streams$1, boolean mainInteractive$1, PrintLogger.State printLoggerState$1, Path serverDir$1, boolean colored$1, Colors colors$1, TailManager tailManager$1, Map env$1, Some threadCount$1, RunnerState stateCache$1, Function1 systemExit$1, SystemStreams streams0$1, boolean enterKeyPressed, Option prevState) {
        MODULE$.adjustJvmProperties(userSpecifiedProperties$1, initialSystemProperties$1);
        return (Watching.Result)MODULE$.withOutLock(config$1.noBuildLock().value() || bspContext$1.isDefined(), config$1.noWaitForBuildLock().value(), out$1, targetsAndParams$1, streams$1, (Function0<Watching.Result> & Serializable)() -> (Watching.Result)Using$.MODULE$.resource(MODULE$.getLogger(streams$1, config$1, mainInteractive$1, config$1.ticker().orElse((Function0<Option> & Serializable)() -> config$1.enableTicker()).orElse((Function0<Option> & Serializable)() -> Option$.MODULE$.when(config$1.disableTicker().value(), () -> false)), printLoggerState$1, serverDir$1, colored$1, colors$1), (Function1<ColorLogger, Watching.Result> & Serializable)logger -> {
            Serializable serializable = enterKeyPressed ? BoxesRunTime.boxToBoolean(remove$.MODULE$.apply(out$1.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-selective-execution.json"})))))) : BoxedUnit.UNIT;
            return (Watching.Result)SystemStreams$.MODULE$.withStreams(logger.systemStreams(), (Function0<Watching.Result> & Serializable)() -> (Watching.Result)tailManager$1.withOutErr(logger.outputStream(), logger.errorStream(), (Function0<Watching.Result> & Serializable)() -> new MillBuildBootstrap(WorkspaceRoot$.MODULE$.workspaceRoot(), out$1, config$1.home(), config$1.keepGoing().value(), config$1.imports(), env$1, threadCount$1, targetsAndParams$1, (RunnerState)prevState.getOrElse((Function0<RunnerState> & Serializable)() -> stateCache$1), (ColorLogger)logger, config$1.disableCallgraph().value(), MODULE$.needBuildFile(config$1), config$1.metaLevel(), config$1.allowPositional().value(), systemExit$1, streams0$1, config$1.watch().value()).evaluate()));
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$main0$20(BooleanRef repeatForBsp$1, SystemStreams streams$1, String bspCmd$1, BspContext ctx) {
        Option<BspServerResult> option = BspContext$.MODULE$.bspServerHandle().lastResult();
        Some<BspServerResult$ReloadWorkspace$> some = new Some<BspServerResult$ReloadWorkspace$>(BspServerResult$ReloadWorkspace$.MODULE$);
        repeatForBsp$1.elem = !(option != null ? !option.equals(some) : some != null);
        streams$1.err().println(new StringBuilder(17).append("`").append(bspCmd$1).append("` returned with ").append(BspContext$.MODULE$.bspServerHandle().lastResult()).toString());
    }

    public static final /* synthetic */ void $anonfun$main0$10(MillCliConfig config$1, Path out$1, SystemStreams streams$1, Function1 setIdle$1, Map userSpecifiedProperties$1, Map initialSystemProperties$1, Option bspContext$1, Seq targetsAndParams$1, boolean mainInteractive$1, PrintLogger.State printLoggerState$1, Path serverDir$1, boolean colored$1, Colors colors$1, Map env$1, Some threadCount$1, RunnerState stateCache$1, Function1 systemExit$1, SystemStreams streams0$1, BooleanRef repeatForBsp$1, String bspCmd$1, ObjectRef loopRes$1, TailManager tailManager) {
        Serializable serializable = config$1.watch().value() ? BoxesRunTime.boxToBoolean(remove$.MODULE$.apply(out$1.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-selective-execution.json"})))))) : BoxedUnit.UNIT;
        Tuple2 tuple2 = Watching$.MODULE$.watchLoop(config$1.ringBell().value(), config$1.watch().value(), streams$1, setIdle$1, (Function2<Object, Option, Watching.Result> & Serializable)(enterKeyPressed, prevState) -> MillMain$.$anonfun$main0$11(userSpecifiedProperties$1, initialSystemProperties$1, config$1, bspContext$1, out$1, targetsAndParams$1, streams$1, mainInteractive$1, printLoggerState$1, serverDir$1, colored$1, colors$1, tailManager, env$1, threadCount$1, stateCache$1, systemExit$1, streams0$1, BoxesRunTime.unboxToBoolean(enterKeyPressed), prevState), colors$1);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean isSuccess = tuple2._1$mcZ$sp();
        RunnerState evalStateOpt = (RunnerState)tuple2._2();
        Tuple2<Boolean, RunnerState> tuple22 = new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(isSuccess), evalStateOpt);
        boolean isSuccess2 = tuple22._1$mcZ$sp();
        RunnerState evalStateOpt2 = tuple22._2();
        bspContext$1.foreach((Function1<BspContext, Object> & Serializable)ctx -> {
            MillMain$.$anonfun$main0$20(repeatForBsp$1, streams$1, bspCmd$1, ctx);
            return BoxedUnit.UNIT;
        });
        loopRes$1.elem = new Tuple2<Boolean, RunnerState>(BoxesRunTime.boxToBoolean(isSuccess2), evalStateOpt2);
    }

    public static final /* synthetic */ void $anonfun$main0$21(SystemStreams streams$1, BspContext ctx) {
        streams$1.err().println(new StringBuilder(59).append("Exiting BSP runner loop. Stopping BSP server. Last result: ").append(BspContext$.MODULE$.bspServerHandle().lastResult()).toString());
        BspContext$.MODULE$.bspServerHandle().stop();
    }

    private static final String err$2(String detail, Option threadCountRaw$1) {
        return new StringBuilder(37).append("Invalid value \"").append(threadCountRaw$1.getOrElse((Function0<String> & Serializable)() -> "")).append("\" for flag -j/--jobs: ").append(detail).toString();
    }

    public static final /* synthetic */ boolean $anonfun$needBuildFile$1(Seq targetsAndParams$2, String x$9) {
        Object a = targetsAndParams$2.head();
        String string = x$9;
        return !(a != null ? !a.equals(string) : string != null);
    }

    public static final /* synthetic */ void $anonfun$checkMillVersionFromFile$2(PrintStream stderr$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Path file = (Path)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String version = (String)some.value();
                String string = BuildInfo$.MODULE$.millVersion();
                String string2 = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(version), "-native");
                if (string == null ? string2 != null : !string.equals(string2)) {
                    String msg = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(102).append("Mill version ").append(BuildInfo$.MODULE$.millVersion()).append(" is different than configured for this directory!\n             |Configured version is ").append(version).append(" (").append(file).append(")").toString()));
                    stderr$1.println(msg);
                    return;
                }
                return;
            }
        }
        throw new MatchError(tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$adjustJvmProperties$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private static final String activeTaskString$1(Path out$2) {
        String string;
        try {
            string = read$.MODULE$.apply(out$2.$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"mill-active-command"})))));
        }
        catch (Throwable e) {
            string = "<unknown>";
        }
        return string;
    }

    private static final String activeTaskPrefix$1(Path out$2) {
        return new StringBuilder(35).append("Another Mill process is running '").append(MillMain$.activeTaskString$1(out$2)).append("',").toString();
    }

    private MillMain$() {
    }
}

