/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.harmony.pack200;

import java.util.Arrays;

public class IntList {
    private int[] array;
    private int firstIndex;
    private int lastIndex;
    private int modCount;

    public IntList() {
        this(10);
    }

    public IntList(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.lastIndex = 0;
        this.firstIndex = 0;
        this.array = new int[capacity];
    }

    public boolean add(int object) {
        if (this.lastIndex == this.array.length) {
            this.growAtEnd(1);
        }
        this.array[this.lastIndex++] = object;
        ++this.modCount;
        return true;
    }

    public void add(int location, int object) {
        int size2 = this.lastIndex - this.firstIndex;
        if (0 < location && location < size2) {
            if (this.firstIndex == 0 && this.lastIndex == this.array.length) {
                this.growForInsert(location, 1);
            } else if (location < size2 / 2 && this.firstIndex > 0 || this.lastIndex == this.array.length) {
                System.arraycopy(this.array, this.firstIndex, this.array, --this.firstIndex, location);
            } else {
                int index = location + this.firstIndex;
                System.arraycopy(this.array, index, this.array, index + 1, size2 - location);
                ++this.lastIndex;
            }
            this.array[location + this.firstIndex] = object;
        } else if (location == 0) {
            if (this.firstIndex == 0) {
                this.growAtFront(1);
            }
            this.array[--this.firstIndex] = object;
        } else if (location == size2) {
            if (this.lastIndex == this.array.length) {
                this.growAtEnd(1);
            }
            this.array[this.lastIndex++] = object;
        } else {
            throw new IndexOutOfBoundsException();
        }
        ++this.modCount;
    }

    public void addAll(IntList list2) {
        this.growAtEnd(list2.size());
        for (int i = 0; i < list2.size(); ++i) {
            this.add(list2.get(i));
        }
    }

    public void clear() {
        if (this.firstIndex != this.lastIndex) {
            Arrays.fill(this.array, this.firstIndex, this.lastIndex, -1);
            this.lastIndex = 0;
            this.firstIndex = 0;
            ++this.modCount;
        }
    }

    public int get(int location) {
        if (0 <= location && location < this.lastIndex - this.firstIndex) {
            return this.array[this.firstIndex + location];
        }
        throw new IndexOutOfBoundsException("" + location);
    }

    private void growAtEnd(int required) {
        int size2 = this.lastIndex - this.firstIndex;
        if (this.firstIndex >= required - (this.array.length - this.lastIndex)) {
            int newLast = this.lastIndex - this.firstIndex;
            if (size2 > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, 0, size2);
            }
            this.firstIndex = 0;
            this.lastIndex = newLast;
        } else {
            int increment = size2 / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            int[] newArray = new int[size2 + increment];
            if (size2 > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, 0, size2);
                this.firstIndex = 0;
                this.lastIndex = size2;
            }
            this.array = newArray;
        }
    }

    private void growAtFront(int required) {
        int size2 = this.lastIndex - this.firstIndex;
        if (this.array.length - this.lastIndex + this.firstIndex >= required) {
            int newFirst = this.array.length - size2;
            if (size2 > 0) {
                System.arraycopy(this.array, this.firstIndex, this.array, newFirst, size2);
            }
            this.firstIndex = newFirst;
            this.lastIndex = this.array.length;
        } else {
            int increment = size2 / 2;
            if (required > increment) {
                increment = required;
            }
            if (increment < 12) {
                increment = 12;
            }
            int[] newArray = new int[size2 + increment];
            if (size2 > 0) {
                System.arraycopy(this.array, this.firstIndex, newArray, newArray.length - size2, size2);
            }
            this.firstIndex = newArray.length - size2;
            this.lastIndex = newArray.length;
            this.array = newArray;
        }
    }

    private void growForInsert(int location, int required) {
        int size2 = this.lastIndex - this.firstIndex;
        int increment = size2 / 2;
        if (required > increment) {
            increment = required;
        }
        if (increment < 12) {
            increment = 12;
        }
        int[] newArray = new int[size2 + increment];
        int newFirst = increment - required;
        System.arraycopy(this.array, location + this.firstIndex, newArray, newFirst + location + required, size2 - location);
        System.arraycopy(this.array, this.firstIndex, newArray, newFirst, location);
        this.firstIndex = newFirst;
        this.lastIndex = size2 + increment;
        this.array = newArray;
    }

    public void increment(int location) {
        if (0 > location || location >= this.lastIndex - this.firstIndex) {
            throw new IndexOutOfBoundsException("" + location);
        }
        int n = this.firstIndex + location;
        this.array[n] = this.array[n] + 1;
    }

    public boolean isEmpty() {
        return this.lastIndex == this.firstIndex;
    }

    public int remove(int location) {
        int result2;
        int size2 = this.lastIndex - this.firstIndex;
        if (0 > location || location >= size2) {
            throw new IndexOutOfBoundsException();
        }
        if (location == size2 - 1) {
            result2 = this.array[--this.lastIndex];
            this.array[this.lastIndex] = 0;
        } else if (location == 0) {
            result2 = this.array[this.firstIndex];
            this.array[this.firstIndex++] = 0;
        } else {
            int elementIndex = this.firstIndex + location;
            result2 = this.array[elementIndex];
            if (location < size2 / 2) {
                System.arraycopy(this.array, this.firstIndex, this.array, this.firstIndex + 1, location);
                this.array[this.firstIndex++] = 0;
            } else {
                System.arraycopy(this.array, elementIndex + 1, this.array, elementIndex, size2 - location - 1);
                this.array[--this.lastIndex] = 0;
            }
        }
        if (this.firstIndex == this.lastIndex) {
            this.lastIndex = 0;
            this.firstIndex = 0;
        }
        ++this.modCount;
        return result2;
    }

    public int size() {
        return this.lastIndex - this.firstIndex;
    }

    public int[] toArray() {
        int size2 = this.lastIndex - this.firstIndex;
        int[] result2 = new int[size2];
        System.arraycopy(this.array, this.firstIndex, result2, 0, size2);
        return result2;
    }
}

