//**************************************************************************************************
//                                         PrcPdfVwr.hpp                                           *
//                                        ---------------                                          *
// Description : Provides an interface to a PDF documentation file viewing utility.                *
// Started     : 2020-08-03                                                                        *
// Last Update : 2020-09-30                                                                        *
// Copyright   : (C) 2020 MSWaters                                                                 *
//**************************************************************************************************

//**************************************************************************************************
//                                                                                                 *
//      This program is free software; you can redistribute it and/or modify it under the          *
//      terms of the GNU General Public License as published by the Free Software Foundation;      *
//      either version 3 of the License, or (at your option) any later version.                    *
//                                                                                                 *
//**************************************************************************************************

#ifndef PRCPDFVWR_HPP
#define PRCPDFVWR_HPP

// Application Includes

#include "TypeDefs.hpp"
#include "SysScan.hpp"
#include "base/PrcBase.hpp"

//**************************************************************************************************

class PrcPdfVwr : public PrcBase
{
  private :

    wxFileName  m_ofnNamePdf;  // The PDF file name

  public :

    static  wxArrayString  m_osaPdfVwrBinLst;  // A list of possible PDF viewer binary names

          PrcPdfVwr( void );
         ~PrcPdfVwr( );

    // Function for automatically finding PDF file viewer utility binaries
    static  void  InitPdfVwrBinLst( void );

    bool  bSetPdfFile( const wxString & rosFileName );

    const wxFileName & rofnGetPdfFile( void ) { return( m_ofnNamePdf ); }

    virtual  bool  bExec( void );
};

//**************************************************************************************************

#endif // PRCPDFVWR_HPP
