/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.MultiRangeReference;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0015B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/com/intellij/psi/MultiRangeReference;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "resolvesByNames", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "getRangeInElement", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/TextRange;", "getRanges", "", "getRange", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "canRename", "", "Companion", "kt-references"})
public abstract class KtInvokeFunctionReference
extends KtSimpleReference<KtCallExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES = CollectionsKt.listOf((Object)OperatorNameConventions.INVOKE);

    public KtInvokeFunctionReference(@NotNull KtCallExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super((KtReferenceExpression)expression2);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtCallExpression)this.getElement()).getTextRange().shiftRight(-((KtCallExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
        return textRange;
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        KtValueArgumentList valueArgumentList = ((KtCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            List<KtValueArgument> list2 = valueArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getArguments(...)");
            if (!((Collection)list2).isEmpty()) {
                ASTNode rPar;
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                ASTNode valueArgumentListNode = aSTNode;
                ASTNode lPar = valueArgumentListNode.findChildByType(KtTokens.LPAR);
                if (lPar != null) {
                    list.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType(KtTokens.RPAR)) != null) {
                    list.add(this.getRange(rPar));
                }
            } else {
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                list.add(this.getRange(aSTNode));
            }
        }
        List<KtLambdaArgument> list3 = ((KtCallExpression)this.getExpression()).getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"getLambdaArguments(...)");
        List<KtLambdaArgument> functionLiteralArguments = list3;
        for (KtLambdaArgument functionLiteralArgument : functionLiteralArguments) {
            KtLambdaExpression functionLiteralExpression;
            if (functionLiteralArgument.getLambdaExpression() == null) continue;
            ASTNode aSTNode = functionLiteralExpression.getLeftCurlyBrace();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getLeftCurlyBrace(...)");
            list.add(this.getRange(aSTNode));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list.add(this.getRange(rightCurlyBrace));
        }
        return list;
    }

    private final TextRange getRange(ASTNode node) {
        TextRange textRange = node.getTextRange();
        TextRange textRange2 = textRange.shiftRight(-((KtCallExpression)this.getExpression()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"shiftRight(...)");
        return textRange2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference$Companion;", "", "<init>", "()V", "NAMES", "", "Lorg/jetbrains/kotlin/name/Name;", "kt-references"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

