/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.Closeable;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheMetadata;
import org.gradle.api.internal.artifacts.ivyservice.CacheLayout;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.UnscopedCacheBuilderFactory;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Serializer;

public class ReadOnlyArtifactCacheLockingAccessCoordinator
implements ArtifactCacheLockingAccessCoordinator,
Closeable {
    private static final Logger LOGGER = Logging.getLogger(ReadOnlyArtifactCacheLockingAccessCoordinator.class);
    private final PersistentCache cache;

    public ReadOnlyArtifactCacheLockingAccessCoordinator(UnscopedCacheBuilderFactory unscopedCacheBuilderFactory, ArtifactCacheMetadata cacheMetaData) {
        this.cache = unscopedCacheBuilderFactory.cache(cacheMetaData.getCacheDir()).withDisplayName("read only artifact cache").withInitialLockMode(FileLockManager.LockMode.None).open();
    }

    @Override
    public void close() {
        this.cache.close();
    }

    public <T> T withFileLock(Supplier<? extends T> action) {
        return (T)this.cache.withFileLock(action);
    }

    public void withFileLock(Runnable action) {
        this.cache.withFileLock(action);
    }

    public <T> T useCache(Supplier<? extends T> action) {
        return (T)this.cache.useCache(action);
    }

    public void useCache(Runnable action) {
        this.cache.useCache(action);
    }

    @Override
    public <K, V> IndexedCache<K, V> createCache(String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        String cacheFileInMetaDataStore = CacheLayout.META_DATA.getKey() + "/" + cacheName;
        IndexedCacheParameters parameters = IndexedCacheParameters.of((String)cacheFileInMetaDataStore, keySerializer, valueSerializer);
        if (this.cache.indexedCacheExists(parameters)) {
            return new TransparentCacheLockingIndexedCache(new FailSafeIndexedCache(this.cache.createIndexedCache(parameters)));
        }
        return new EmptyIndexedCache();
    }

    private class TransparentCacheLockingIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> indexedCache;

        public TransparentCacheLockingIndexedCache(IndexedCache<K, V> indexedCache) {
            this.indexedCache = indexedCache;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.get(key, producer));
        }

        public void put(K key, V value) {
            ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.put(key, value));
        }

        public void remove(K key) {
            ReadOnlyArtifactCacheLockingAccessCoordinator.this.cache.useCache(() -> this.indexedCache.remove(key));
        }
    }

    private static class FailSafeIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private final IndexedCache<K, V> delegate;
        private boolean failed;

        private FailSafeIndexedCache(IndexedCache<K, V> delegate) {
            this.delegate = delegate;
        }

        @Nullable
        public V getIfPresent(K key) {
            return (V)this.failSafe(() -> this.delegate.getIfPresent(key));
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return (V)this.failSafe(() -> this.delegate.get(key, producer));
        }

        public void put(K key, V value) {
        }

        public void remove(K key) {
        }

        private <T> T failSafe(Factory<T> operation) {
            if (this.failed) {
                return null;
            }
            try {
                return (T)operation.create();
            }
            catch (Exception ex) {
                this.failed = true;
                LOGGER.debug("Error accessing read-only cache", (Throwable)ex);
                return null;
            }
        }
    }

    private static class EmptyIndexedCache<K, V>
    implements IndexedCache<K, V> {
        private EmptyIndexedCache() {
        }

        @Nullable
        public V getIfPresent(K key) {
            return null;
        }

        public V get(K key, Function<? super K, ? extends V> producer) {
            return producer.apply(key);
        }

        public void put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        public void remove(K key) {
            throw new UnsupportedOperationException();
        }
    }
}

