/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.preferences.sources.ExtendedSourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourceEntry;
import org.openstreetmap.josm.data.preferences.sources.SourcePrefHelper;
import org.openstreetmap.josm.data.preferences.sources.SourceProvider;
import org.openstreetmap.josm.data.preferences.sources.SourceType;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.util.DocumentAdapter;
import org.openstreetmap.josm.gui.util.FileFilterAllFiles;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.ReorderableTableModel;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.gui.widgets.FilterField;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public abstract class SourceEditor
extends JPanel {
    private static final String DELETE = "delete";
    private static final String DIALOGS = "dialogs";
    protected final SourceType sourceType;
    protected final boolean canEnable;
    protected final JTable tblActiveSources;
    protected final ActiveSourcesModel activeSourcesModel;
    protected final JTable tblAvailableSources;
    protected final AvailableSourcesModel availableSourcesModel;
    protected final String availableSourcesUrl;
    protected final transient List<SourceProvider> sourceProviders;
    private JTable tblIconPaths;
    private IconPathTableModel iconPathsModel;
    protected boolean sourcesInitiallyLoaded;

    protected SourceEditor(SourceType sourceType, String availableSourcesUrl, List<SourceProvider> sourceProviders, boolean handleIcons) {
        this.sourceType = sourceType;
        this.canEnable = sourceType == SourceType.MAP_PAINT_STYLE || sourceType == SourceType.TAGCHECKER_RULE;
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.availableSourcesModel = new AvailableSourcesModel();
        this.tblAvailableSources = new ScrollHackTable(this.availableSourcesModel);
        this.availableSourcesModel.addTableModelListener(e -> TableHelper.adjustColumnWidth(this.tblAvailableSources, 0, 800));
        this.availableSourcesModel.removeTableModelListener(this.tblAvailableSources);
        this.availableSourcesModel.addTableModelListener(this.tblAvailableSources);
        this.tblAvailableSources.setAutoCreateRowSorter(true);
        this.tblAvailableSources.setSelectionModel(selectionModel);
        FancySourceEntryTableCellRenderer availableSourcesEntryRenderer = new FancySourceEntryTableCellRenderer();
        this.tblAvailableSources.getColumnModel().getColumn(0).setCellRenderer(availableSourcesEntryRenderer);
        GuiHelper.extendTooltipDelay(this.tblAvailableSources);
        this.availableSourcesUrl = availableSourcesUrl;
        this.sourceProviders = sourceProviders;
        selectionModel = new DefaultListSelectionModel();
        this.activeSourcesModel = new ActiveSourcesModel(selectionModel);
        this.tblActiveSources = new ScrollHackTable(this.activeSourcesModel);
        this.tblActiveSources.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblActiveSources.setSelectionModel(selectionModel);
        Stream.of(this.tblAvailableSources, this.tblActiveSources).forEach(t -> {
            t.setSelectionMode(2);
            t.setShowGrid(false);
            t.setIntercellSpacing(new Dimension(0, 0));
            t.setTableHeader(null);
            t.setAutoResizeMode(0);
        });
        SourceEntryTableCellRenderer sourceEntryRenderer = new SourceEntryTableCellRenderer();
        if (this.canEnable) {
            this.tblActiveSources.getColumnModel().getColumn(0).setMaxWidth(1);
            this.tblActiveSources.getColumnModel().getColumn(0).setResizable(false);
            this.tblActiveSources.getColumnModel().getColumn(1).setCellRenderer(sourceEntryRenderer);
        } else {
            this.tblActiveSources.getColumnModel().getColumn(0).setCellRenderer(sourceEntryRenderer);
        }
        this.activeSourcesModel.addTableModelListener(e -> {
            availableSourcesEntryRenderer.updateSources(this.activeSourcesModel.getSources());
            this.tblAvailableSources.repaint();
        });
        this.tblActiveSources.addPropertyChangeListener(evt -> {
            availableSourcesEntryRenderer.updateSources(this.activeSourcesModel.getSources());
            this.tblAvailableSources.repaint();
        });
        this.activeSourcesModel.addTableModelListener(e -> TableHelper.adjustColumnWidth(this.tblActiveSources, this.canEnable ? 1 : 0, 800));
        this.activeSourcesModel.setActiveSources(this.getInitialSourcesList());
        final EditActiveSourceAction editActiveSourceAction = new EditActiveSourceAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(editActiveSourceAction);
        this.tblActiveSources.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int row = SourceEditor.this.tblActiveSources.rowAtPoint(e.getPoint());
                    int col = SourceEditor.this.tblActiveSources.columnAtPoint(e.getPoint());
                    if (row < 0 || row >= SourceEditor.this.tblActiveSources.getRowCount()) {
                        return;
                    }
                    if (SourceEditor.this.canEnable && col != 1) {
                        return;
                    }
                    editActiveSourceAction.actionPerformed(null);
                }
            }
        });
        RemoveActiveSourcesAction removeActiveSourcesAction = new RemoveActiveSourcesAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(removeActiveSourcesAction);
        this.tblActiveSources.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), DELETE);
        this.tblActiveSources.getActionMap().put(DELETE, removeActiveSourcesAction);
        MoveUpDownAction moveUp = null;
        MoveUpDownAction moveDown = null;
        if (sourceType == SourceType.MAP_PAINT_STYLE) {
            moveUp = new MoveUpDownAction(false);
            moveDown = new MoveUpDownAction(true);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUp);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveDown);
            this.activeSourcesModel.addTableModelListener(moveUp);
            this.activeSourcesModel.addTableModelListener(moveDown);
        }
        ActivateSourcesAction activateSourcesAction = new ActivateSourcesAction();
        this.tblAvailableSources.getSelectionModel().addListSelectionListener(activateSourcesAction);
        JButton activate = new JButton(activateSourcesAction);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 11, 0, 0);
        this.add((Component)new JLabel(this.getStr(I18nString.AVAILABLE_SOURCES)), gbc);
        gbc.gridx = 2;
        gbc.insets = new Insets(5, 0, 0, 6);
        this.add((Component)new JLabel(this.getStr(I18nString.ACTIVE_SOURCES)), gbc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 0.8;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 11, 0, 0);
        FilterField availableSourcesFilter = new FilterField().filter(this.tblAvailableSources, this.availableSourcesModel);
        JPanel defaultPane = new JPanel(new GridBagLayout());
        JScrollPane sp1 = new JScrollPane(this.tblAvailableSources);
        defaultPane.add((Component)availableSourcesFilter, GBC.eol().insets(0, 0, 0, 0).fill(2));
        defaultPane.add((Component)sp1, GBC.eol().insets(0, 0, 0, 0).fill(1));
        this.add((Component)defaultPane, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 0);
        JToolBar middleTB = new JToolBar();
        middleTB.setFloatable(false);
        middleTB.setBorderPainted(false);
        middleTB.setOpaque(false);
        middleTB.add(Box.createHorizontalGlue());
        middleTB.add(activate);
        middleTB.add(Box.createHorizontalGlue());
        this.add((Component)middleTB, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.5;
        gbc.fill = 1;
        JScrollPane sp = new JScrollPane(this.tblActiveSources);
        this.add((Component)sp, gbc);
        sp.setColumnHeaderView(null);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 6);
        JToolBar sideButtonTB = new JToolBar(1);
        sideButtonTB.setFloatable(false);
        sideButtonTB.setBorderPainted(false);
        sideButtonTB.setOpaque(false);
        sideButtonTB.add(new NewActiveSourceAction());
        sideButtonTB.add(editActiveSourceAction);
        sideButtonTB.add(removeActiveSourcesAction);
        sideButtonTB.addSeparator(new Dimension(12, 30));
        if (sourceType == SourceType.MAP_PAINT_STYLE) {
            sideButtonTB.add(moveUp);
            sideButtonTB.add(moveDown);
        }
        this.add((Component)sideButtonTB, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weighty = 0.0;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 11, 0, 0);
        JToolBar bottomLeftTB = new JToolBar();
        bottomLeftTB.setFloatable(false);
        bottomLeftTB.setBorderPainted(false);
        bottomLeftTB.setOpaque(false);
        bottomLeftTB.add(new ReloadSourcesAction(availableSourcesUrl, sourceProviders));
        bottomLeftTB.add(Box.createHorizontalGlue());
        this.add((Component)bottomLeftTB, gbc);
        gbc.gridx = 2;
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 0, 0);
        JToolBar bottomRightTB = new JToolBar();
        bottomRightTB.setFloatable(false);
        bottomRightTB.setBorderPainted(false);
        bottomRightTB.setOpaque(false);
        bottomRightTB.add(Box.createHorizontalGlue());
        bottomRightTB.add(new JButton(new ResetAction()));
        this.add((Component)bottomRightTB, gbc);
        if (handleIcons) {
            this.buildIcons(gbc);
        }
    }

    private void buildIcons(GridBagConstraints gbc) {
        DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
        this.iconPathsModel = new IconPathTableModel(selectionModel);
        this.tblIconPaths = new JTable(this.iconPathsModel);
        TableHelper.setFont(this.tblIconPaths, this.getClass());
        this.tblIconPaths.setSelectionModel(selectionModel);
        this.tblIconPaths.setSelectionMode(2);
        this.tblIconPaths.setTableHeader(null);
        this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
        this.tblIconPaths.setRowHeight(20);
        this.tblIconPaths.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.iconPathsModel.setIconPaths(this.getInitialIconPathsList());
        EditIconPathAction editIconPathAction = new EditIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
        RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
        this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), DELETE);
        this.tblIconPaths.getActionMap().put(DELETE, removeIconPathAction);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = 0;
        gbc.insets = new Insets(8, 11, 8, 6);
        this.add((Component)new JSeparator(), gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 11, 0, 6);
        this.add((Component)new JLabel(I18n.tr("Icon paths:", new Object[0])), gbc);
        ++gbc.gridy;
        gbc.weighty = 0.2;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 11, 0, 0);
        JScrollPane sp = new JScrollPane(this.tblIconPaths);
        this.add((Component)sp, gbc);
        sp.setColumnHeaderView(null);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        gbc.insets = new Insets(0, 0, 0, 6);
        JToolBar sideButtonTBIcons = new JToolBar(1);
        sideButtonTBIcons.setFloatable(false);
        sideButtonTBIcons.setBorderPainted(false);
        sideButtonTBIcons.setOpaque(false);
        sideButtonTBIcons.add(new NewIconPathAction());
        sideButtonTBIcons.add(editIconPathAction);
        sideButtonTBIcons.add(removeIconPathAction);
        this.add((Component)sideButtonTBIcons, gbc);
    }

    public abstract Collection<? extends SourceEntry> getInitialSourcesList();

    public abstract Collection<String> getInitialIconPathsList();

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract boolean finish();

    protected boolean doFinish(SourcePrefHelper prefHelper, String iconPref) {
        boolean changed = prefHelper.put(this.activeSourcesModel.getSources());
        if (this.tblIconPaths != null) {
            List<String> iconPaths = this.iconPathsModel.getIconPaths();
            if (!iconPaths.isEmpty()) {
                if (Config.getPref().putList(iconPref, iconPaths)) {
                    changed = true;
                }
            } else if (Config.getPref().putList(iconPref, null)) {
                changed = true;
            }
        }
        return changed;
    }

    protected abstract String getStr(I18nString var1);

    public boolean hasActiveSourcesChanged() {
        Collection<? extends SourceEntry> prev = this.getInitialSourcesList();
        List<SourceEntry> cur = this.activeSourcesModel.getSources();
        if (prev.size() != cur.size()) {
            return true;
        }
        Iterator<? extends SourceEntry> p = prev.iterator();
        Iterator<SourceEntry> c = cur.iterator();
        while (p.hasNext()) {
            SourceEntry pe = p.next();
            SourceEntry ce = c.next();
            if (Objects.equals(pe.url, ce.url) && Objects.equals(pe.name, ce.name) && pe.active == ce.active) continue;
            return true;
        }
        return false;
    }

    public Collection<SourceEntry> getActiveSources() {
        return this.activeSourcesModel.getSources();
    }

    public final Collection<ExtendedSourceEntry> loadAndGetAvailableSources() throws SAXException, IOException, OsmTransferException {
        SourceLoader loader = new SourceLoader(this.availableSourcesUrl, this.sourceProviders);
        loader.realRun();
        return loader.sources;
    }

    public void removeSources(Collection<Integer> idxs) {
        this.activeSourcesModel.removeIdxs(idxs);
    }

    protected void reloadAvailableSources(String url, List<SourceProvider> sourceProviders) {
        MainApplication.worker.submit(new SourceLoader(url, sourceProviders));
    }

    public void initiallyLoadAvailableSources() {
        if (!this.sourcesInitiallyLoaded && !NetworkManager.isOffline(OnlineResource.CACHE_UPDATES)) {
            this.reloadAvailableSources(this.availableSourcesUrl, this.sourceProviders);
        }
        this.sourcesInitiallyLoaded = true;
    }

    private static void prepareFileChooser(String url, AbstractFileChooser fc) {
        URL sourceUrl;
        if (Utils.isStripEmpty(url)) {
            return;
        }
        try {
            sourceUrl = new URL(url);
        }
        catch (MalformedURLException e) {
            File f = new File(url);
            if (f.isFile()) {
                f = f.getParentFile();
            }
            if (f != null) {
                fc.setCurrentDirectory(f);
            }
            return;
        }
        if (sourceUrl.getProtocol().startsWith("file")) {
            File f = new File(sourceUrl.getPath());
            if (f.isFile()) {
                f = f.getParentFile();
            }
            if (f != null) {
                fc.setCurrentDirectory(f);
            }
        }
    }

    public final void deferLoading(DefaultTabPreferenceSetting tab, Component component) {
        this.deferLoading(tab.getTabPane(), component);
    }

    public final void deferLoading(JTabbedPane tab, Component component) {
        tab.addChangeListener(e -> {
            if (tab.getSelectedComponent() == component) {
                this.initiallyLoadAvailableSources();
            }
        });
    }

    protected String getTitleForSourceEntry(SourceEntry entry) {
        return "".equals(entry.title) ? null : entry.title;
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private final JosmTextField tfFileName = new JosmTextField();
        private final CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private final boolean isFile;

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.gridx = 0;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            this.add((Component)this.tfFileName, gc);
            gc.gridx = 1;
            gc.gridy = 0;
            gc.fill = 1;
            gc.weightx = 0.0;
            gc.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserEditCellAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        FileOrUrlCellEditor(boolean isFile) {
            this.isFile = isFile;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            if (l != null) {
                this.listeners.addIfAbsent(l);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener l : this.listeners) {
                l.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener l : this.listeners) {
                l.editingStopped(new ChangeEvent(this));
            }
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= 2;
            }
            return true;
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.remove(l);
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String initialValue) {
            this.value = initialValue;
            this.tfFileName.setText(Objects.requireNonNullElse(initialValue, ""));
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.setInitialValue((String)value);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserEditCellAction
        extends AbstractAction {
            LaunchFileChooserEditCellAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserManager fcm = new FileChooserManager(true).createFileChooser();
                if (!FileOrUrlCellEditor.this.isFile) {
                    fcm.getFileChooser().setFileSelectionMode(1);
                }
                SourceEditor.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), fcm.getFileChooser());
                AbstractFileChooser fc = fcm.openFileChooser(GuiHelper.getFrameForComponent(SourceEditor.this));
                if (fc != null) {
                    FileOrUrlCellEditor.this.tfFileName.setText(fc.getSelectedFile().toString());
                }
            }
        }
    }

    static class SourceEntryTableCellRenderer
    extends DefaultTableCellRenderer {
        SourceEntryTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return this;
            }
            return super.getTableCellRendererComponent(table, SourceEntryTableCellRenderer.fromSourceEntry((SourceEntry)value), isSelected, hasFocus, row, column);
        }

        private static String fromSourceEntry(SourceEntry entry) {
            if (entry == null) {
                return null;
            }
            StringBuilder s = new StringBuilder(128).append("<html><b>");
            if (entry.title != null) {
                s.append(Utils.escapeReservedCharactersHTML(entry.title)).append("</b> <span color=\"gray\">");
            }
            s.append(entry.url);
            if (entry.title != null) {
                s.append("</span>");
            }
            s.append("</html>");
            return s.toString();
        }
    }

    class SourceLoader
    extends PleaseWaitRunnable {
        private final String url;
        private final List<SourceProvider> sourceProviders;
        private CachedFile cachedFile;
        private boolean canceled;
        private final List<ExtendedSourceEntry> sources;

        SourceLoader(String url, List<SourceProvider> sourceProviders) {
            super(I18n.tr(SourceEditor.this.getStr(I18nString.LOADING_SOURCES_FROM), url));
            this.sources = new ArrayList<ExtendedSourceEntry>();
            this.url = url;
            this.sourceProviders = sourceProviders;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            Utils.close(this.cachedFile);
        }

        protected void warn(Exception e) {
            String emsg = Utils.escapeReservedCharactersHTML(e.getMessage() != null ? e.getMessage() : e.toString());
            String msg = I18n.tr(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM), this.url, emsg);
            GuiHelper.runInEDT(() -> HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg, I18n.tr("Error", new Object[0]), 0, HelpUtil.ht(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC))));
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.sources.addAll(SourceEditor.this.getDefault());
                for (SourceProvider provider : this.sourceProviders) {
                    for (SourceEntry src : provider.getSources()) {
                        if (!(src instanceof ExtendedSourceEntry)) continue;
                        this.sources.add((ExtendedSourceEntry)src);
                    }
                }
                this.readFile();
                if (this.sources.removeIf(extendedSourceEntry -> "xml".equals(extendedSourceEntry.styleType))) {
                    Logging.debug("Removing XML source entry");
                }
            }
            catch (IOException e) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException ex = new OsmTransferException(e);
                ex.setUrl(this.url);
                this.warn(ex);
            }
        }

        protected void readFile() throws IOException {
            String lang = LanguageInfo.getLanguageCodeXML();
            this.cachedFile = new CachedFile(this.url);
            try (BufferedReader reader = this.cachedFile.getContentReader();){
                String line;
                ExtendedSourceEntry last = null;
                while ((line = reader.readLine()) != null && !this.canceled) {
                    Matcher m;
                    if (line.trim().isEmpty()) continue;
                    if (line.startsWith("\t")) {
                        m = Pattern.compile("^\t([^:]+): *(.+)$").matcher(line);
                        if (!m.matches()) {
                            Logging.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, line));
                            continue;
                        }
                        if (last == null) continue;
                        String key = m.group(1);
                        String value = m.group(2);
                        if ("author".equals(key) && last.author == null) {
                            last.author = value;
                            continue;
                        }
                        if ("version".equals(key)) {
                            last.version = value;
                            continue;
                        }
                        if ("icon".equals(key) && last.icon == null) {
                            last.icon = new ImageProvider(value).setOptional(true).getResource();
                            continue;
                        }
                        if ("link".equals(key) && last.link == null) {
                            last.link = value;
                            continue;
                        }
                        if ("description".equals(key) && last.description == null) {
                            last.description = value;
                            continue;
                        }
                        if ((lang + "shortdescription").equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("shortdescription".equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ((lang + "title").equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("title".equals(key) && last.title == null) {
                            last.title = value;
                            continue;
                        }
                        if ("name".equals(key) && last.name == null) {
                            last.name = value;
                            continue;
                        }
                        if ((lang + "author").equals(key)) {
                            last.author = value;
                            continue;
                        }
                        if ((lang + "link").equals(key)) {
                            last.link = value;
                            continue;
                        }
                        if ((lang + "description").equals(key)) {
                            last.description = value;
                            continue;
                        }
                        if ("min-josm-version".equals(key)) {
                            try {
                                last.minJosmVersion = Integer.valueOf(value);
                            }
                            catch (NumberFormatException e) {
                                Logging.trace(e);
                            }
                            continue;
                        }
                        if (!"style-type".equals(key)) continue;
                        last.styleType = value;
                        continue;
                    }
                    last = null;
                    m = Pattern.compile("^(.+);(.+)$").matcher(line);
                    if (m.matches()) {
                        last = new ExtendedSourceEntry(SourceEditor.this.sourceType, m.group(1), m.group(2));
                        this.sources.add(last);
                        continue;
                    }
                    Logging.error(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, line));
                }
            }
        }

        @Override
        protected void finish() {
            Collections.sort(this.sources);
            SourceEditor.this.availableSourcesModel.setSources(this.sources);
        }
    }

    static class FancySourceEntryTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final NamedColorProperty SOURCE_ENTRY_ACTIVE_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("External resource entry: Active"), new Color(200, 255, 200));
        private static final NamedColorProperty SOURCE_ENTRY_INACTIVE_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("External resource entry: Inactive"), new Color(200, 200, 200));
        private final Map<String, SourceEntry> entryByUrl = new HashMap<String, SourceEntry>();

        FancySourceEntryTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable list, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(list, object, isSelected, hasFocus, row, column);
            if (object instanceof ExtendedSourceEntry) {
                ExtendedSourceEntry value = (ExtendedSourceEntry)object;
                String s = value.toString();
                this.setText(s);
                this.setToolTipText(value.getTooltip());
                if (!isSelected) {
                    SourceEntry sourceEntry = this.entryByUrl.get(value.url);
                    GuiHelper.setBackgroundReadable(this, sourceEntry == null ? UIManager.getColor("Table.background") : (sourceEntry.active ? SOURCE_ENTRY_ACTIVE_BACKGROUND_COLOR.get() : SOURCE_ENTRY_INACTIVE_BACKGROUND_COLOR.get()));
                }
                ImageProvider.ImageSizes size = ImageProvider.ImageSizes.TABLE;
                this.setIcon(value.icon == null ? ImageProvider.getEmpty(size) : value.icon.getImageIconBounded(size.getImageDimension()));
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateSources(List<SourceEntry> sources) {
            Map<String, SourceEntry> map = this.entryByUrl;
            synchronized (map) {
                this.entryByUrl.clear();
                for (SourceEntry i : sources) {
                    this.entryByUrl.put(i.url, i);
                }
            }
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path", new Object[0]));
            new ImageProvider(SourceEditor.DIALOGS, "edit").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = SourceEditor.this.tblIconPaths.getSelectedRow();
            SourceEditor.this.tblIconPaths.editCellAt(row, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths", new Object[0]));
            new ImageProvider(SourceEditor.DIALOGS, SourceEditor.DELETE).getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        NewIconPathAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path", new Object[0]));
            new ImageProvider(SourceEditor.DIALOGS, "add").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.iconPathsModel.addPath("");
            SourceEditor.this.tblIconPaths.editCellAt(SourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    protected static class IconPathTableModel
    extends AbstractTableModel {
        private final List<String> data;
        private final DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList<String>();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.updatePath(rowIndex, (String)aValue);
        }

        public void setIconPaths(Collection<String> paths) {
            this.data.clear();
            if (paths != null) {
                this.data.addAll(paths);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String path) {
            if (path == null) {
                return;
            }
            this.data.add(path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void updatePath(int pos, String path) {
            if (path == null) {
                return;
            }
            if (pos < 0 || pos >= this.getRowCount()) {
                return;
            }
            this.data.set(pos, path);
            this.sort();
            this.fireTableDataChanged();
            int idx = this.data.indexOf(path);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<String> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            this.data.sort((o1, o2) -> {
                if (o1.isEmpty() && o2.isEmpty()) {
                    return 0;
                }
                if (o1.isEmpty()) {
                    return 1;
                }
                if (o2.isEmpty()) {
                    return -1;
                }
                return o1.compareTo((String)o2);
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    class ReloadSourcesAction
    extends AbstractAction {
        private final String url;
        private final transient List<SourceProvider> sourceProviders;

        ReloadSourcesAction(String url, List<SourceProvider> sourceProviders) {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr(SourceEditor.this.getStr(I18nString.RELOAD_ALL_AVAILABLE), url));
            new ImageProvider(SourceEditor.DIALOGS, "refresh").getResource().attachImageIcon(this);
            this.url = url;
            this.sourceProviders = sourceProviders;
            this.setEnabled(!NetworkManager.isOffline(OnlineResource.JOSM_WEBSITE));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CachedFile.cleanup(this.url);
            SourceEditor.this.reloadAvailableSources(this.url, this.sourceProviders);
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            this.putValue("Name", I18n.tr("Reset", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reset to default", new Object[0]));
            new ImageProvider("preferences", "reset").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.setActiveSources(SourceEditor.this.getDefault());
        }
    }

    class ActivateSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        ActivateSourcesAction() {
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.ACTIVATE_TOOLTIP));
            new ImageProvider("preferences", "activate-right").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblAvailableSources.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ExtendedSourceEntry> sources = Arrays.stream(SourceEditor.this.tblAvailableSources.getSelectedRows()).map(SourceEditor.this.tblAvailableSources::convertRowIndexToModel).mapToObj(SourceEditor.this.availableSourcesModel::getValueAt).collect(Collectors.toList());
            int josmVersion = Version.getInstance().getVersion();
            if (josmVersion != 0) {
                ArrayList<String> messages = new ArrayList<String>();
                for (ExtendedSourceEntry entry : sources) {
                    if (entry.minJosmVersion == null || entry.minJosmVersion <= josmVersion) continue;
                    messages.add(I18n.tr("Entry ''{0}'' requires JOSM Version {1}. (Currently running: {2})", entry.title, Integer.toString(entry.minJosmVersion), Integer.toString(josmVersion)));
                }
                if (!messages.isEmpty()) {
                    ExtendedDialog dlg = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Warning", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Continue anyway", new Object[0]));
                    dlg.setButtonIcons(ImageProvider.get("cancel"), new ImageProvider("ok").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get());
                    dlg.setToolTipTexts(I18n.tr("Cancel and return to the previous dialog", new Object[0]), I18n.tr("Ignore warning and install style anyway", new Object[0]));
                    dlg.setContent("<html>" + I18n.tr("Some entries have unmet dependencies:", new Object[0]) + "<br>" + String.join((CharSequence)"<br>", messages) + "</html>");
                    dlg.setIcon(2);
                    if (dlg.showDialog().getValue() != 2) {
                        return;
                    }
                }
            }
            SourceEditor.this.activeSourcesModel.addExtendedSourceEntries(sources);
        }
    }

    class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        private final int increment;

        MoveUpDownAction(boolean isDown) {
            this.increment = isDown ? 1 : -1;
            new ImageProvider(SourceEditor.DIALOGS, isDown ? "down" : "up").getResource().attachImageIcon(this, true);
            this.putValue("ShortDescription", isDown ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.activeSourcesModel.canMove(this.increment));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.move(this.increment, SourceEditor.this.tblActiveSources.getSelectedRows());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateEnabledState();
        }
    }

    class EditActiveSourceAction
    extends AbstractAction
    implements ListSelectionListener {
        EditActiveSourceAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.EDIT_SOURCE_TOOLTIP));
            new ImageProvider(SourceEditor.DIALOGS, "edit").getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() == 1);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int pos = SourceEditor.this.tblActiveSources.getSelectedRow();
            if (pos < 0 || pos >= SourceEditor.this.tblActiveSources.getRowCount()) {
                return;
            }
            SourceEntry e = (SourceEntry)SourceEditor.this.activeSourcesModel.getValueAt(pos, 1);
            EditSourceEntryDialog editEntryDialog = new EditSourceEntryDialog(SourceEditor.this, I18n.tr("Edit source entry:", new Object[0]), e);
            editEntryDialog.showDialog();
            if (editEntryDialog.getValue() == 1) {
                if (e.title != null || !"".equals(editEntryDialog.getTitle())) {
                    e.title = editEntryDialog.getTitle();
                    e.title = SourceEditor.this.getTitleForSourceEntry(e);
                }
                e.url = editEntryDialog.getURL();
                if (SourceEditor.this.canEnable) {
                    e.active = editEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.fireTableRowsUpdated(pos, pos);
            }
        }
    }

    class RemoveActiveSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveActiveSourcesAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.REMOVE_SOURCE_TOOLTIP));
            new ImageProvider(SourceEditor.DIALOGS, SourceEditor.DELETE).getResource().attachImageIcon(this);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SourceEditor.this.activeSourcesModel.removeSelected();
        }
    }

    class NewActiveSourceAction
    extends AbstractAction {
        NewActiveSourceAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY_TOOLTIP));
            new ImageProvider(SourceEditor.DIALOGS, "add").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            EditSourceEntryDialog editEntryDialog = new EditSourceEntryDialog(SourceEditor.this, SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY), null);
            editEntryDialog.showDialog();
            if (editEntryDialog.getValue() == 1) {
                boolean active = true;
                if (SourceEditor.this.canEnable) {
                    active = editEntryDialog.active();
                }
                SourceEntry entry = new SourceEntry(SourceEditor.this.sourceType, editEntryDialog.getURL(), null, editEntryDialog.getTitle(), active);
                entry.title = SourceEditor.this.getTitleForSourceEntry(entry);
                SourceEditor.this.activeSourcesModel.addSource(entry);
                SourceEditor.this.activeSourcesModel.fireTableDataChanged();
            }
        }
    }

    protected class EditSourceEntryDialog
    extends ExtendedDialog {
        private final JosmTextField tfTitle;
        private final JosmTextField tfURL;
        private JCheckBox cbActive;

        public EditSourceEntryDialog(Component parent, String title, SourceEntry e) {
            super(parent, title, I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0]));
            JPanel p = new JPanel(new GridBagLayout());
            this.tfTitle = new JosmTextField(60);
            p.add((Component)new JLabel(I18n.tr("Name (optional):", new Object[0])), GBC.std().insets(15, 0, 5, 5));
            p.add((Component)this.tfTitle, GBC.eol().insets(0, 0, 5, 5));
            this.tfURL = new JosmTextField(60);
            p.add((Component)new JLabel(I18n.tr("URL / File:", new Object[0])), GBC.std().insets(15, 0, 5, 0));
            p.add((Component)this.tfURL, GBC.std().insets(0, 0, 5, 5));
            JButton fileChooser = new JButton(new LaunchFileChooserSourceTypeAction());
            fileChooser.setMargin(new Insets(0, 0, 0, 0));
            p.add((Component)fileChooser, GBC.eol().insets(0, 0, 5, 5));
            if (e != null) {
                if (e.title != null) {
                    this.tfTitle.setText(e.title);
                }
                this.tfURL.setText(e.url);
            }
            if (SourceEditor.this.canEnable) {
                this.cbActive = new JCheckBox(I18n.tr("active", new Object[0]), e == null || e.active);
                p.add((Component)this.cbActive, GBC.eol().insets(15, 0, 5, 0));
            }
            this.setButtonIcons("ok", "cancel");
            this.setContent(p);
            this.tfURL.getDocument().addDocumentListener(DocumentAdapter.create(ignore -> this.updateOkButtonState()));
        }

        private void updateOkButtonState() {
            ((JButton)this.buttons.get(0)).setEnabled(!Utils.isStripEmpty(this.tfURL.getText()));
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            this.updateOkButtonState();
        }

        @Override
        public String getTitle() {
            return this.tfTitle.getText();
        }

        public String getURL() {
            return this.tfURL.getText();
        }

        public boolean active() {
            if (!SourceEditor.this.canEnable) {
                throw new UnsupportedOperationException();
            }
            return this.cbActive.isSelected();
        }

        class LaunchFileChooserSourceTypeAction
        extends AbstractAction {
            LaunchFileChooserSourceTypeAction() {
                new ImageProvider("open").getResource().attachImageIcon(this);
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtensionFileFilter ff;
                switch (SourceEditor.this.sourceType) {
                    case MAP_PAINT_STYLE: {
                        ff = new ExtensionFileFilter("xml,mapcss,css,zip", "xml", I18n.tr("Map paint style file (*.xml, *.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGGING_PRESET: {
                        ff = new ExtensionFileFilter("xml,zip", "xml", I18n.tr("Preset definition file (*.xml, *.zip)", new Object[0]));
                        break;
                    }
                    case TAGCHECKER_RULE: {
                        ff = new ExtensionFileFilter("validator.mapcss,zip", "validator.mapcss", I18n.tr("Tag checker rule (*.validator.mapcss, *.zip)", new Object[0]));
                        break;
                    }
                    default: {
                        Logging.error("Unsupported source type: " + String.valueOf((Object)SourceEditor.this.sourceType));
                        return;
                    }
                }
                FileChooserManager fcm = new FileChooserManager(true).createFileChooser(true, null, Arrays.asList(ff, FileFilterAllFiles.getInstance()), ff, 0);
                SourceEditor.prepareFileChooser(EditSourceEntryDialog.this.tfURL.getText(), fcm.getFileChooser());
                AbstractFileChooser fc = fcm.openFileChooser(GuiHelper.getFrameForComponent(SourceEditor.this));
                if (fc != null) {
                    EditSourceEntryDialog.this.tfURL.setText(fc.getSelectedFile().toString());
                }
            }
        }
    }

    protected class ActiveSourcesModel
    extends AbstractTableModel
    implements ReorderableTableModel<SourceEntry> {
        private transient List<SourceEntry> data;
        private final DefaultListSelectionModel selectionModel;

        public ActiveSourcesModel(DefaultListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.data = new ArrayList<SourceEntry>();
        }

        @Override
        public int getColumnCount() {
            return SourceEditor.this.canEnable ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (SourceEditor.this.canEnable && columnIndex == 0) {
                return this.data.get((int)rowIndex).active;
            }
            return this.data.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return SourceEditor.this.canEnable && columnIndex == 0;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (SourceEditor.this.canEnable && column == 0) {
                return Boolean.class;
            }
            return SourceEntry.class;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (row < 0 || row >= this.getRowCount() || aValue == null) {
                return;
            }
            if (SourceEditor.this.canEnable && column == 0) {
                this.data.get((int)row).active = !this.data.get((int)row).active;
            }
        }

        public void setActiveSources(Collection<? extends SourceEntry> sources) {
            this.data.clear();
            if (sources != null) {
                for (SourceEntry sourceEntry : sources) {
                    this.data.add(new SourceEntry(sourceEntry));
                }
            }
            this.fireTableDataChanged();
        }

        public void addSource(SourceEntry entry) {
            if (entry == null) {
                return;
            }
            this.data.add(entry);
            this.fireTableDataChanged();
            int idx = this.data.indexOf(entry);
            if (idx >= 0) {
                this.selectionModel.setSelectionInterval(idx, idx);
            }
        }

        public void removeSelected() {
            Iterator<SourceEntry> it = this.data.iterator();
            int i = 0;
            while (it.hasNext()) {
                it.next();
                if (this.selectionModel.isSelectedIndex(i)) {
                    it.remove();
                }
                ++i;
            }
            this.fireTableDataChanged();
        }

        public void removeIdxs(Collection<Integer> idxs) {
            this.data = IntStream.range(0, this.data.size()).filter(i -> !idxs.contains(i)).mapToObj(this.data::get).collect(Collectors.toList());
            this.fireTableDataChanged();
        }

        public void addExtendedSourceEntries(List<ExtendedSourceEntry> sources) {
            if (sources == null) {
                return;
            }
            for (ExtendedSourceEntry info : sources) {
                this.data.add(new SourceEntry(info.type, info.url, info.name, info.getDisplayName(), true));
            }
            this.fireTableDataChanged();
            TableHelper.setSelectedIndices(this.selectionModel, sources.stream().mapToInt(this.data::indexOf));
        }

        public List<SourceEntry> getSources() {
            return new ArrayList<SourceEntry>(this.data);
        }

        @Override
        public DefaultListSelectionModel getSelectionModel() {
            return this.selectionModel;
        }

        @Override
        public SourceEntry getValue(int index) {
            return this.data.get(index);
        }

        @Override
        public SourceEntry setValue(int index, SourceEntry value) {
            return this.data.set(index, value);
        }
    }

    protected static class AvailableSourcesModel
    extends AbstractTableModel {
        private final transient List<ExtendedSourceEntry> data = new ArrayList<ExtendedSourceEntry>();

        public void setSources(List<ExtendedSourceEntry> sources) {
            this.data.clear();
            if (sources != null) {
                this.data.addAll(sources);
            }
            this.fireTableDataChanged();
        }

        public ExtendedSourceEntry getValueAt(int rowIndex) {
            return this.data.get(rowIndex);
        }

        @Override
        public ExtendedSourceEntry getValueAt(int rowIndex, int ignored) {
            return this.getValueAt(rowIndex);
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }
    }

    public static enum I18nString {
        AVAILABLE_SOURCES,
        ACTIVE_SOURCES,
        NEW_SOURCE_ENTRY_TOOLTIP,
        NEW_SOURCE_ENTRY,
        REMOVE_SOURCE_TOOLTIP,
        EDIT_SOURCE_TOOLTIP,
        ACTIVATE_TOOLTIP,
        RELOAD_ALL_AVAILABLE,
        LOADING_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC,
        ILLEGAL_FORMAT_OF_ENTRY;

    }

    static final class ScrollHackTable
    extends JTable {
        ScrollHackTable(TableModel dm) {
            super(dm);
        }

        @Override
        public void scrollRectToVisible(Rectangle aRect) {
            super.scrollRectToVisible(new Rectangle(0, aRect.y, aRect.width, aRect.height));
        }
    }
}

