/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001-2002 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef TRANSLATOR_H
#define TRANSLATOR_H
#include <map>
using std::map;

#include "global.h"

class Translator{
 public:
	Translator(void);
	Translator(const char*);
	~Translator(void);

	void set_language(const char*);
	char* get_language(void);
	const char* get_text_by_ID(int);

 private:
	int load_ressource_file();
	char* to_ascii(char*);
	char* strTrim(const char*);
	char* strLeft(const char*,int);
	char* strRight(const char*,int);
	char *language;
	std::map<int,char*> *trad;
};
#endif












