/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events;

import java.nio.charset.Charset;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileAttributes;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.newvfs.events.VFileEvent;

public final class VFilePropertyChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final String myPropertyName;
    private final Object myOldValue;
    private final Object myNewValue;

    public VFilePropertyChangeEvent(Object requestor, @NotNull VirtualFile file2, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue, boolean isFromRefresh) {
        if (file2 == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(1);
        }
        super(requestor, isFromRefresh);
        this.myFile = file2;
        this.myPropertyName = propertyName;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        VFilePropertyChangeEvent.checkPropertyValuesCorrect(requestor, propertyName, oldValue, newValue);
    }

    public static void checkPropertyValuesCorrect(Object requestor, @NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(2);
        }
        if (Comparing.equal(oldValue, newValue) && "FileContentUtilCore.saveOrReload" != requestor) {
            throw new IllegalArgumentException("Values must be different, got the same: " + oldValue);
        }
        switch (propertyName) {
            case "name": {
                if (oldValue == null) {
                    throw new IllegalArgumentException("oldName must not be null");
                }
                if (!(oldValue instanceof String)) {
                    throw new IllegalArgumentException("oldName must be String, got " + oldValue);
                }
                if (newValue == null) {
                    throw new IllegalArgumentException("newName must not be null");
                }
                if (newValue instanceof String) break;
                throw new IllegalArgumentException("newName must be String, got " + newValue);
            }
            case "encoding": {
                if (oldValue == null) {
                    throw new IllegalArgumentException("oldCharset must not be null");
                }
                if (oldValue instanceof Charset) break;
                throw new IllegalArgumentException("oldValue must be Charset, got " + oldValue);
            }
            case "writable": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldWriteable must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newWriteable must be boolean, got " + newValue);
            }
            case "HIDDEN": {
                if (!(oldValue instanceof Boolean)) {
                    throw new IllegalArgumentException("oldHidden must be boolean, got " + oldValue);
                }
                if (newValue instanceof Boolean) break;
                throw new IllegalArgumentException("newHidden must be boolean, got " + newValue);
            }
            case "symlink": {
                if (oldValue != null && !(oldValue instanceof String)) {
                    throw new IllegalArgumentException("oldSymTarget must be String, got " + oldValue);
                }
                if (newValue == null || newValue instanceof String) break;
                throw new IllegalArgumentException("newSymTarget must be String, got " + newValue);
            }
            case "CHILDREN_CASE_SENSITIVITY": {
                if (!(oldValue instanceof FileAttributes.CaseSensitivity)) {
                    throw new IllegalArgumentException("oldValue must be FileAttributes.CaseSensitivity but got " + oldValue);
                }
                if (!(newValue instanceof FileAttributes.CaseSensitivity)) {
                    throw new IllegalArgumentException("newValue must be FileAttributes.CaseSensitivity but got " + newValue);
                }
                if (!oldValue.equals(newValue)) break;
                throw new IllegalArgumentException("newValue must be different from the oldValue but got " + newValue);
            }
            default: {
                throw new IllegalArgumentException("Unknown property name '" + propertyName + "'. Must be one of VirtualFile.{PROP_NAME|PROP_ENCODING|PROP_WRITABLE|PROP_HIDDEN|PROP_SYMLINK_TARGET}");
            }
        }
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    public Object getNewValue() {
        return this.myNewValue;
    }

    public Object getOldValue() {
        return this.myOldValue;
    }

    @NotNull
    public String getPropertyName() {
        String string2 = this.myPropertyName;
        if (string2 == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(7);
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFilePropertyChangeEvent event = (VFilePropertyChangeEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!Objects.equals(this.myNewValue, event.myNewValue)) {
            return false;
        }
        if (!Objects.equals(this.myOldValue, event.myOldValue)) {
            return false;
        }
        return this.myPropertyName.equals(event.myPropertyName);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myPropertyName.hashCode();
        result2 = 31 * result2 + (this.myOldValue != null ? this.myOldValue.hashCode() : 0);
        result2 = 31 * result2 + (this.myNewValue != null ? this.myNewValue.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String toString() {
        String string2 = "VfsEvent[property(" + this.myPropertyName + ") changed for '" + this.myFile + "': " + this.myOldValue + " -> " + this.myNewValue + ']';
        if (string2 == null) {
            VFilePropertyChangeEvent.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathWithFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkPropertyValuesCorrect";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

