/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.compile.DefaultJvmLanguageCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.MinimalJavaCompileOptions;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.tasks.compile.CompileOptions;

public class DefaultJavaCompileSpec
extends DefaultJvmLanguageCompileSpec
implements JavaCompileSpec {
    private MinimalJavaCompileOptions compileOptions;
    private List<File> annotationProcessorPath;
    private Set<AnnotationProcessorDeclaration> effectiveAnnotationProcessors;
    private Set<String> classesToProcess;
    private List<File> modulePath;
    private List<File> sourceRoots;
    private Set<String> classesToCompile = Collections.emptySet();
    private File backupDestinationDir;

    @Override
    public MinimalJavaCompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    @Override
    @Nullable
    public File getClassBackupDir() {
        return this.backupDestinationDir;
    }

    @Override
    public void setClassBackupDir(@Nullable File classBackupDir) {
        this.backupDestinationDir = classBackupDir;
    }

    public void setCompileOptions(CompileOptions compileOptions) {
        this.compileOptions = new MinimalJavaCompileOptions(compileOptions);
    }

    @Override
    public List<File> getAnnotationProcessorPath() {
        return this.annotationProcessorPath;
    }

    @Override
    public void setAnnotationProcessorPath(List<File> annotationProcessorPath) {
        this.annotationProcessorPath = annotationProcessorPath;
    }

    @Override
    public Set<AnnotationProcessorDeclaration> getEffectiveAnnotationProcessors() {
        return this.effectiveAnnotationProcessors;
    }

    @Override
    public void setEffectiveAnnotationProcessors(Set<AnnotationProcessorDeclaration> annotationProcessors) {
        this.effectiveAnnotationProcessors = annotationProcessors;
    }

    @Override
    public Set<String> getClassesToProcess() {
        return this.classesToProcess;
    }

    @Override
    public void setClassesToProcess(Set<String> classes) {
        this.classesToProcess = classes;
    }

    @Override
    public void setClassesToCompile(Set<String> classes) {
        this.classesToCompile = classes;
    }

    @Override
    public Set<String> getClassesToCompile() {
        return this.classesToCompile;
    }

    @Override
    public List<File> getModulePath() {
        if (this.modulePath == null || this.modulePath.isEmpty()) {
            int i = 0;
            ArrayList<String> modulePaths = new ArrayList<String>();
            for (String argObj : this.compileOptions.getCompilerArgs()) {
                String arg = argObj.toString();
                if ((arg.equals("--module-path") || arg.equals("-p")) && i + 1 < this.compileOptions.getCompilerArgs().size()) {
                    String argValue = this.compileOptions.getCompilerArgs().get(++i);
                    String[] modules = argValue.toString().split(File.pathSeparator);
                    modulePaths.addAll(Arrays.asList(modules));
                } else if (arg.startsWith("--module-path=")) {
                    String[] modules = arg.replace("--module-path=", "").split(File.pathSeparator);
                    modulePaths.addAll(Arrays.asList(modules));
                }
                ++i;
            }
            this.modulePath = (List)modulePaths.stream().map(File::new).collect(ImmutableList.toImmutableList());
        }
        return this.modulePath;
    }

    @Override
    public void setModulePath(List<File> modulePath) {
        this.modulePath = modulePath;
    }

    public List<File> getSourceRoots() {
        return this.sourceRoots;
    }

    public void setSourcesRoots(List<File> sourcesRoots) {
        this.sourceRoots = sourcesRoots;
    }
}

