/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.launcher.bootstrap.ExecutionListener;
import org.gradle.launcher.configuration.BuildLayoutResult;

public class NativeServicesInitializingAction
implements Action<ExecutionListener> {
    private final BuildLayoutResult buildLayout;
    private final LoggingConfiguration loggingConfiguration;
    private final LoggingManagerInternal loggingManager;
    private final Action<ExecutionListener> action;

    public NativeServicesInitializingAction(BuildLayoutResult buildLayout, LoggingConfiguration loggingConfiguration, LoggingManagerInternal loggingManager, Action<ExecutionListener> action) {
        this.buildLayout = buildLayout;
        this.loggingConfiguration = loggingConfiguration;
        this.loggingManager = loggingManager;
        this.action = action;
    }

    @Override
    public void execute(ExecutionListener executionListener) {
        NativeServices.initializeOnClient((File)this.buildLayout.getGradleUserHomeDir());
        this.loggingManager.attachProcessConsole(this.loggingConfiguration.getConsoleOutput());
        this.action.execute(executionListener);
    }
}

