/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.iterator;

import io.usethesource.capsule.util.iterator.SupplierIterator;
import java.util.NoSuchElementException;

public class ArraySupplierIterator<E>
implements SupplierIterator<E, E> {
    final Object[] values;
    final int end;
    int currentIndex;
    E currentElement;

    public ArraySupplierIterator(Object[] values, int start, int end) {
        assert (start <= end && end <= values.length);
        this.values = values;
        this.end = end;
        this.currentIndex = start;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.end;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentElement = this.values[this.currentIndex++];
        return this.currentElement;
    }

    @Override
    public E get() {
        return this.currentElement;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public static <E> SupplierIterator<E, E> of(Object[] array) {
        return new ArraySupplierIterator<E>(array, 0, array.length);
    }

    public static <E> SupplierIterator<E, E> of(Object[] array, int start, int length) {
        return new ArraySupplierIterator<E>(array, start, start + length);
    }
}

