/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.accessors;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.kotlin.dsl.accessors.AccessorsClassPathKt;
import org.gradle.kotlin.dsl.accessors.ClassNamesFromTypeString;
import org.gradle.kotlin.dsl.accessors.HasTypeParameterClassVisitor;
import org.gradle.kotlin.dsl.accessors.InaccessibilityReason;
import org.gradle.kotlin.dsl.accessors.KotlinVisibilityClassVisitor;
import org.gradle.kotlin.dsl.accessors.SchemaType;
import org.gradle.kotlin.dsl.accessors.TypeAccessibility;
import org.gradle.kotlin.dsl.accessors.TypeAccessibilityInfo;
import org.gradle.kotlin.dsl.internal.sharedruntime.support.ClassBytesRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J$\u0010!\u001a\u0002H\"\"\b\b\u0000\u0010\"*\u00020#*\u00020\u00172\u0006\u0010$\u001a\u0002H\"H\u0082\u0002\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider;", "Ljava/io/Closeable;", "classPath", "Lorg/gradle/internal/classpath/ClassPath;", "(Lorg/gradle/internal/classpath/ClassPath;)V", "classBytesRepository", "Lorg/gradle/kotlin/dsl/internal/sharedruntime/support/ClassBytesRepository;", "typeAccessibilityInfoPerClass", "", "", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibilityInfo;", "accessibilityForType", "Lorg/gradle/kotlin/dsl/accessors/TypeAccessibility;", "type", "Lorg/gradle/kotlin/dsl/accessors/SchemaType;", "accessibilityInfoFor", "className", "close", "", "hasTypeParameter", "", "hasTypeParameters", "classReader", "Lorg/jetbrains/org/objectweb/asm/ClassReader;", "inaccessibilityReasonsFor", "", "Lorg/gradle/kotlin/dsl/accessors/InaccessibilityReason;", "classNames", "Lorg/gradle/kotlin/dsl/accessors/ClassNamesFromTypeString;", "isNonPublicKotlinType", "kotlinVisibilityFor", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Visibility;", "loadAccessibilityInfoFor", "invoke", "T", "Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "visitor", "(Lorg/jetbrains/org/objectweb/asm/ClassReader;Lorg/jetbrains/org/objectweb/asm/ClassVisitor;)Lorg/jetbrains/org/objectweb/asm/ClassVisitor;", "kotlin-dsl"})
@SourceDebugExtension(value={"SMAP\nAccessorsClassPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessorsClassPath.kt\norg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,656:1\n1360#2:657\n1446#2,5:658\n766#2:663\n857#2,2:664\n1549#2:666\n1620#2,3:667\n1#3:670\n*S KotlinDebug\n*F\n+ 1 AccessorsClassPath.kt\norg/gradle/kotlin/dsl/accessors/TypeAccessibilityProvider\n*L\n321#1:657\n321#1:658,5\n323#1:663\n323#1:664,2\n323#1:666\n323#1:667,3\n*E\n"})
public final class TypeAccessibilityProvider
implements Closeable {
    @NotNull
    private final ClassBytesRepository classBytesRepository;
    @NotNull
    private final Map<String, TypeAccessibilityInfo> typeAccessibilityInfoPerClass;

    public TypeAccessibilityProvider(@NotNull ClassPath classPath) {
        Intrinsics.checkNotNullParameter((Object)classPath, (String)"classPath");
        ClassLoader classLoader = ClassLoaderUtils.getPlatformClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getPlatformClassLoader()");
        List list2 = classPath.getAsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"classPath.asFiles");
        this.classBytesRepository = new ClassBytesRepository(classLoader, list2, null, 4, null);
        this.typeAccessibilityInfoPerClass = new LinkedHashMap();
    }

    @NotNull
    public final TypeAccessibility accessibilityForType(@NotNull SchemaType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<InaccessibilityReason> inaccessibilityReasons = this.inaccessibilityReasonsFor(AccessorsClassPathKt.classNamesFromTypeString(type));
        boolean bl = false;
        return !((Collection)inaccessibilityReasons).isEmpty() ? AccessorsClassPathKt.inaccessible(type, inaccessibilityReasons) : AccessorsClassPathKt.accessible(type);
    }

    /*
     * WARNING - void declaration
     */
    private final List<InaccessibilityReason> inaccessibilityReasonsFor(ClassNamesFromTypeString classNames) {
        List list2;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = classNames.getAll();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.inaccessibilityReasonsFor(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List inaccessibilityReasons = (List)destination$iv$iv;
        boolean bl = false;
        if (!((Collection)inaccessibilityReasons).isEmpty()) {
            list2 = inaccessibilityReasons;
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String p0;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = classNames.getLeaves();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                p0 = (String)element$iv$iv;
                boolean bl2 = false;
                if (!this.hasTypeParameter(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(AccessorsClassPathKt.typeErasure(p0));
            }
            list2 = (List)destination$iv$iv2;
        }
        return list2;
    }

    private final List<InaccessibilityReason> inaccessibilityReasonsFor(String className) {
        return this.accessibilityInfoFor(className).getInaccessibilityReasons();
    }

    private final boolean hasTypeParameter(String className) {
        return this.accessibilityInfoFor(className).getHasTypeParameter();
    }

    private final TypeAccessibilityInfo accessibilityInfoFor(String className) {
        TypeAccessibilityInfo typeAccessibilityInfo = this.typeAccessibilityInfoPerClass.computeIfAbsent(className, new Function(this){
            final /* synthetic */ TypeAccessibilityProvider this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public final TypeAccessibilityInfo apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return TypeAccessibilityProvider.access$loadAccessibilityInfoFor(this.this$0, it);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)typeAccessibilityInfo, (String)"private\n    fun accessib\u2026lityInfoFor(it)\n        }");
        return typeAccessibilityInfo;
    }

    private final TypeAccessibilityInfo loadAccessibilityInfoFor(String className) {
        byte[] byArray = this.classBytesRepository.classBytesFor(className);
        if (byArray == null) {
            return new TypeAccessibilityInfo(CollectionsKt.listOf((Object)AccessorsClassPathKt.nonAvailable(className)), false, 2, null);
        }
        byte[] classBytes2 = byArray;
        ClassReader classReader = new ClassReader(classBytes2);
        int access = classReader.getAccess();
        return new TypeAccessibilityInfo(CollectionsKt.listOfNotNull((Object)(!AccessorsClassPathKt.access$contains(access, 1) ? AccessorsClassPathKt.nonPublic(className) : (AccessorsClassPathKt.access$contains(access, 4096) ? AccessorsClassPathKt.synthetic(className) : (this.isNonPublicKotlinType(classReader) ? AccessorsClassPathKt.nonPublic(className) : null)))), this.hasTypeParameters(classReader));
    }

    private final boolean isNonPublicKotlinType(ClassReader classReader) {
        boolean bl;
        ProtoBuf.Visibility visibility = this.kotlinVisibilityFor(classReader);
        if (visibility != null) {
            ProtoBuf.Visibility it = visibility;
            boolean bl2 = false;
            bl = it != ProtoBuf.Visibility.PUBLIC;
        } else {
            bl = false;
        }
        return bl;
    }

    private final ProtoBuf.Visibility kotlinVisibilityFor(ClassReader classReader) {
        return ((KotlinVisibilityClassVisitor)this.invoke(classReader, (ClassVisitor)new KotlinVisibilityClassVisitor())).getVisibility();
    }

    private final boolean hasTypeParameters(ClassReader classReader) {
        return ((HasTypeParameterClassVisitor)this.invoke(classReader, (ClassVisitor)new HasTypeParameterClassVisitor())).getHasTypeParameters();
    }

    private final <T extends ClassVisitor> T invoke(ClassReader $this$invoke, T visitor2) {
        T t;
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"<this>");
        T it = t = visitor2;
        boolean bl = false;
        $this$invoke.accept(it, 7);
        return t;
    }

    @Override
    public void close() {
        this.classBytesRepository.close();
    }

    public static final /* synthetic */ TypeAccessibilityInfo access$loadAccessibilityInfoFor(TypeAccessibilityProvider $this, String className) {
        return $this.loadAccessibilityInfoFor(className);
    }
}

