/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ast;

import com.vladsch.flexmark.ast.LinkNodeBase;
import com.vladsch.flexmark.util.ast.DoNotLinkDecorate;
import com.vladsch.flexmark.util.ast.NodeVisitor;
import com.vladsch.flexmark.util.ast.TextContainer;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Escaping;
import com.vladsch.flexmark.util.sequence.ReplacedTextMapper;
import com.vladsch.flexmark.util.sequence.builder.ISequenceBuilder;

public abstract class LinkNode
extends LinkNodeBase
implements DoNotLinkDecorate,
TextContainer {
    public LinkNode() {
    }

    public LinkNode(BasedSequence chars) {
        super(chars);
    }

    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        BasedSequence url;
        int urlType = flags & F_LINK_TEXT_TYPE;
        switch (urlType) {
            case 1: {
                url = this.getPageRef();
                break;
            }
            case 2: {
                url = this.getAnchorRef();
                break;
            }
            case 3: {
                url = this.getUrl();
                break;
            }
            case 4: {
                url = BasedSequence.NULL;
                break;
            }
            default: {
                return true;
            }
        }
        if (urlType == 4) {
            out.append((CharSequence)this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(url);
            BasedSequence unescaped = Escaping.unescape((BasedSequence)url, (ReplacedTextMapper)textMapper);
            BasedSequence percentDecoded = Escaping.percentDecodeUrl((BasedSequence)unescaped, (ReplacedTextMapper)textMapper);
            out.append((CharSequence)percentDecoded);
        }
        return false;
    }
}

