/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.dita.dost.util.KeyDef;

public record KeyScope(String id, String name, Map<String, KeyDef> keyDefinition, List<KeyScope> childScopes) {
    public static final String ROOT_ID = "#root";
    public static final KeyScope EMPTY = new KeyScope("#root", null, Collections.emptyMap(), Collections.emptyList());

    public KeyScope(String id, String name, Map<String, KeyDef> keyDefinition, List<KeyScope> childScopes) {
        this.id = id;
        this.name = name;
        this.keyDefinition = Collections.unmodifiableMap(keyDefinition);
        this.childScopes = List.copyOf(childScopes);
    }

    public KeyDef get(String key) {
        return this.keyDefinition.get(key);
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.keyDefinition.keySet());
    }

    public KeyScope getChildScope(String scope) {
        return this.childScopes.stream().filter(s -> s.name.equals(scope)).findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyScope keyScope = (KeyScope)o;
        if (!Objects.equals(this.name, keyScope.name)) {
            return false;
        }
        if (!this.keyDefinition.equals(keyScope.keyDefinition)) {
            return false;
        }
        return this.childScopes.equals(keyScope.childScopes);
    }

    @Override
    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.keyDefinition.hashCode();
        result = 31 * result + this.childScopes.hashCode();
        return result;
    }

    public static KeyScope merge(KeyScope scope1, KeyScope scope2) {
        if (!Objects.equals(scope1.id, scope2.id)) {
            throw new IllegalArgumentException(String.format("Scopes should have the same ID: %s != %s", scope1.id, scope2.id));
        }
        HashMap keyDefinition = new HashMap();
        scope1.keyDefinition.forEach(keyDefinition::putIfAbsent);
        scope2.keyDefinition.forEach(keyDefinition::putIfAbsent);
        ArrayList<KeyScope> childScopes = new ArrayList<KeyScope>();
        childScopes.addAll(scope1.childScopes);
        childScopes.addAll(scope2.childScopes);
        return new KeyScope(scope1.id, scope1.name, Collections.unmodifiableMap(keyDefinition), Collections.unmodifiableList(childScopes));
    }
}

