/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the "License").  You may not use this file except
 * in compliance with the License.
 *
 * You can obtain a copy of the license at
 * glassfish/bootstrap/legal/CDDLv1.0.txt or
 * https://glassfish.dev.java.net/public/CDDLv1.0.html.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * HEADER in each file and include the License file at
 * glassfish/bootstrap/legal/CDDLv1.0.txt.  If applicable,
 * add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your
 * own identifying information: Portions Copyright [yyyy]
 * [name of copyright owner]
 *
 * Copyright 2005 Sun Microsystems, Inc. All rights reserved.
 *
 * Portions Copyright Apache Software Foundation.
 */ 

package javax.servlet.jsp.tagext;

import java.io.InputStream;

/**
 * Translation-time information on a JSP page.  The information
 * corresponds to the XML view of the JSP page.
 *
 * <p>
 * Objects of this type are generated by the JSP translator, e.g.
 * when being pased to a TagLibraryValidator instance.
 */

abstract public class PageData {

    /**
     * Sole constructor. (For invocation by subclass constructors, 
     * typically implicit.)
     */
    public PageData() {
    }
    
    /**
     * Returns an input stream on the XML view of a JSP page.
     * The stream is encoded in UTF-8.  Recall tht the XML view of a 
     * JSP page has the include directives expanded.
     * 
     * @return An input stream on the document.
     */
   abstract public InputStream getInputStream();
}
