/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.internal.Factory;
import org.gradle.internal.jvm.Jvm;
import org.gradle.jvm.toolchain.JavaInstallationMetadata;
import org.gradle.jvm.toolchain.internal.JavaExecutableUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJavaCompileSpecFactory<T extends JavaCompileSpec>
implements Factory<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJavaCompileSpecFactory.class);
    private final CompileOptions compileOptions;
    private final JavaInstallationMetadata toolchain;

    public AbstractJavaCompileSpecFactory(CompileOptions compileOptions, JavaInstallationMetadata toolchain) {
        this.compileOptions = compileOptions;
        this.toolchain = toolchain;
    }

    public T create() {
        File toolchainJavaHome = this.toolchain.getInstallationPath().getAsFile();
        if (!this.toolchain.getLanguageVersion().canCompileOrRun(8)) {
            LOGGER.info("Compilation mode: command line compilation");
            return this.getCommandLineSpec(Jvm.forHome((File)toolchainJavaHome).getJavacExecutable());
        }
        if (this.compileOptions.isFork()) {
            File forkJavaHome = this.compileOptions.getForkOptions().getJavaHome();
            if (forkJavaHome != null) {
                LOGGER.info("Compilation mode: command line compilation");
                return this.getCommandLineSpec(Jvm.forHome((File)forkJavaHome).getJavacExecutable());
            }
            String forkExecutable = this.compileOptions.getForkOptions().getExecutable();
            if (forkExecutable != null) {
                LOGGER.info("Compilation mode: command line compilation");
                return this.getCommandLineSpec(JavaExecutableUtils.resolveExecutable((String)forkExecutable));
            }
            int languageVersion = this.toolchain.getLanguageVersion().asInt();
            LOGGER.info("Compilation mode: forking compiler");
            return this.getForkingSpec(toolchainJavaHome, languageVersion);
        }
        if (this.toolchain.isCurrentJvm() && JdkJavaCompiler.canBeUsed()) {
            LOGGER.info("Compilation mode: in-process compilation");
            return this.getInProcessSpec();
        }
        LOGGER.info("Compilation mode: default, forking compiler");
        return this.getForkingSpec(toolchainJavaHome, this.toolchain.getLanguageVersion().asInt());
    }

    protected abstract T getCommandLineSpec(File var1);

    protected abstract T getForkingSpec(File var1, int var2);

    protected abstract T getInProcessSpec();
}

