/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.provider.plugins.precompiled.tasks;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.provider.plugins.precompiled.tasks.ThreadLocalCapturePrintStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0006\u0010\u0015\u001a\u00020\rJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/gradle/kotlin/dsl/provider/plugins/precompiled/tasks/ThreadLocalCapturePrintStream;", "Ljava/io/PrintStream;", "originalOutput", "<init>", "(Ljava/io/PrintStream;)V", "captureOutput", "Ljava/io/ByteArrayOutputStream;", "getCaptureOutput", "()Ljava/io/ByteArrayOutputStream;", "isCapturing", "Ljava/lang/ThreadLocal;", "", "write", "", "buf", "", "off", "", "len", "b", "flush", "stop", "safely", "block", "Lkotlin/Function0;", "doCapture", "getDoCapture", "()Z", "kotlin-dsl-provider-plugins"})
final class ThreadLocalCapturePrintStream
extends PrintStream {
    @NotNull
    private final ByteArrayOutputStream captureOutput;
    @Nullable
    private ThreadLocal<Boolean> isCapturing;

    public ThreadLocalCapturePrintStream(@NotNull PrintStream originalOutput) {
        Intrinsics.checkNotNullParameter((Object)originalOutput, (String)"originalOutput");
        super(originalOutput);
        this.captureOutput = new ByteArrayOutputStream();
        this.isCapturing = ThreadLocal.withInitial(isCapturing.1.INSTANCE);
        ThreadLocal<Boolean> threadLocal = this.isCapturing;
        Intrinsics.checkNotNull(threadLocal);
        threadLocal.set(true);
    }

    @NotNull
    public final ByteArrayOutputStream getCaptureOutput() {
        return this.captureOutput;
    }

    @Override
    public void write(@NotNull byte[] buf, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        this.safely((Function0<Unit>)((Function0)() -> ThreadLocalCapturePrintStream.write$lambda$0(this, buf, off, len)));
    }

    @Override
    public void write(int b) {
        this.safely((Function0<Unit>)((Function0)() -> ThreadLocalCapturePrintStream.write$lambda$1(this, b)));
    }

    @Override
    public void flush() {
        this.safely((Function0<Unit>)((Function0)() -> ThreadLocalCapturePrintStream.flush$lambda$2(this)));
    }

    public final void stop() {
        this.safely((Function0<Unit>)((Function0)() -> ThreadLocalCapturePrintStream.stop$lambda$3(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void safely(Function0<Unit> block) {
        try {
            ThreadLocalCapturePrintStream threadLocalCapturePrintStream = this;
            synchronized (threadLocalCapturePrintStream) {
                Object object = block.invoke();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getDoCapture() {
        if (this.isCapturing == null) return false;
        ThreadLocal<Boolean> threadLocal = this.isCapturing;
        Intrinsics.checkNotNull(threadLocal);
        if (threadLocal.get() == false) return false;
        return true;
    }

    private static final Unit write$lambda$0(ThreadLocalCapturePrintStream this$0, byte[] $buf, int $off, int $len) {
        if (this$0.getDoCapture()) {
            this$0.captureOutput.write($buf, $off, $len);
        } else {
            super.write($buf, $off, $len);
        }
        return Unit.INSTANCE;
    }

    private static final Unit write$lambda$1(ThreadLocalCapturePrintStream this$0, int $b) {
        if (this$0.getDoCapture()) {
            this$0.captureOutput.write($b);
        } else {
            super.write($b);
        }
        return Unit.INSTANCE;
    }

    private static final Unit flush$lambda$2(ThreadLocalCapturePrintStream this$0) {
        this$0.captureOutput.flush();
        super.flush();
        return Unit.INSTANCE;
    }

    private static final Unit stop$lambda$3(ThreadLocalCapturePrintStream this$0) {
        ThreadLocal<Boolean> threadLocal = this$0.isCapturing;
        Intrinsics.checkNotNull(threadLocal);
        threadLocal.remove();
        this$0.isCapturing = null;
        return Unit.INSTANCE;
    }
}

