/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.config.spring;

import org.apache.ftpserver.config.spring.SpringUtil;
import org.apache.ftpserver.usermanager.ClearTextPasswordEncryptor;
import org.apache.ftpserver.usermanager.DbUserManagerFactory;
import org.apache.ftpserver.usermanager.Md5PasswordEncryptor;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.SaltedPasswordEncryptor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class UserManagerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return null;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Class factoryClass = element.getLocalName().equals("file-user-manager") ? PropertiesUserManagerFactory.class : DbUserManagerFactory.class;
        BeanDefinitionBuilder factoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(factoryClass);
        if (StringUtils.hasText((String)element.getAttribute("encrypt-passwords"))) {
            String encryptionStrategy = element.getAttribute("encrypt-passwords");
            if (encryptionStrategy.equals("true") || encryptionStrategy.equals("md5")) {
                factoryBuilder.addPropertyValue("passwordEncryptor", (Object)new Md5PasswordEncryptor());
            } else if (encryptionStrategy.equals("salted")) {
                factoryBuilder.addPropertyValue("passwordEncryptor", (Object)new SaltedPasswordEncryptor());
            } else {
                factoryBuilder.addPropertyValue("passwordEncryptor", (Object)new ClearTextPasswordEncryptor());
            }
        }
        if (factoryClass == PropertiesUserManagerFactory.class) {
            if (StringUtils.hasText((String)element.getAttribute("file"))) {
                factoryBuilder.addPropertyValue("file", (Object)element.getAttribute("file"));
            }
            if (StringUtils.hasText((String)element.getAttribute("url"))) {
                factoryBuilder.addPropertyValue("url", (Object)element.getAttribute("url"));
            }
        } else {
            Element dsElm = SpringUtil.getChildElement(element, "http://mina.apache.org/ftpserver/spring/v1", "data-source");
            Element springElm = SpringUtil.getChildElement(dsElm, null, null);
            Object o = "bean".equals(springElm.getLocalName()) ? parserContext.getDelegate().parseBeanDefinitionElement(springElm, (BeanDefinition)builder.getBeanDefinition()) : parserContext.getDelegate().parsePropertySubElement(springElm, (BeanDefinition)builder.getBeanDefinition());
            factoryBuilder.addPropertyValue("dataSource", o);
            factoryBuilder.addPropertyValue("sqlUserInsert", (Object)this.getSql(element, "insert-user"));
            factoryBuilder.addPropertyValue("sqlUserUpdate", (Object)this.getSql(element, "update-user"));
            factoryBuilder.addPropertyValue("sqlUserDelete", (Object)this.getSql(element, "delete-user"));
            factoryBuilder.addPropertyValue("sqlUserSelect", (Object)this.getSql(element, "select-user"));
            factoryBuilder.addPropertyValue("sqlUserSelectAll", (Object)this.getSql(element, "select-all-users"));
            factoryBuilder.addPropertyValue("sqlUserAdmin", (Object)this.getSql(element, "is-admin"));
            factoryBuilder.addPropertyValue("sqlUserAuthenticate", (Object)this.getSql(element, "authenticate"));
        }
        AbstractBeanDefinition factoryDefinition = factoryBuilder.getBeanDefinition();
        String factoryId = parserContext.getReaderContext().generateBeanName((BeanDefinition)factoryDefinition);
        BeanDefinitionHolder factoryHolder = new BeanDefinitionHolder((BeanDefinition)factoryDefinition, factoryId);
        this.registerBeanDefinition(factoryHolder, parserContext.getRegistry());
        builder.getRawBeanDefinition().setFactoryBeanName(factoryId);
        builder.getRawBeanDefinition().setFactoryMethodName("createUserManager");
    }

    private String getSql(Element element, String elmName) {
        return SpringUtil.getChildElementText(element, "http://mina.apache.org/ftpserver/spring/v1", elmName);
    }
}

