/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.ManagedServletPipeline;
import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterChainInvocation
implements FilterChain {
    private final List<FilterDefinition> filterDefinitions;
    private final FilterChain proceedingChain;
    private final ManagedServletPipeline servletPipeline;
    private int index = -1;

    public FilterChainInvocation(List<FilterDefinition> filterDefinitions, ManagedServletPipeline servletPipeline, FilterChain proceedingChain) {
        this.filterDefinitions = filterDefinitions;
        this.servletPipeline = servletPipeline;
        this.proceedingChain = proceedingChain;
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        ++this.index;
        if (this.index < this.filterDefinitions.size()) {
            this.filterDefinitions.get(this.index).doFilter(servletRequest, servletResponse, this);
        } else {
            boolean serviced = this.servletPipeline.service(servletRequest, servletResponse);
            if (!serviced) {
                this.proceedingChain.doFilter(servletRequest, servletResponse);
            }
        }
    }
}

