/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver;

import com.google.jstestdriver.Flags;
import com.google.jstestdriver.FlagsImpl;
import com.google.jstestdriver.FlagsParser;
import com.google.jstestdriver.config.CmdFlags;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class Args4jFlagsParser
implements FlagsParser {
    private final CmdFlags cmdLineFlags;

    public Args4jFlagsParser(CmdFlags cmdLineFlags) {
        this.cmdLineFlags = cmdLineFlags;
    }

    public Flags parseArgument(String[] strings) throws CmdLineException {
        FlagsImpl flags = new FlagsImpl();
        CmdLineParser.registerHandler(List.class, StringListOptionHandler.class);
        CmdLineParser.registerHandler(Long.class, LongOptionHandler.class);
        CmdLineParser cmdLineParser = new CmdLineParser(flags);
        try {
            cmdLineParser.parseArgument(strings);
        }
        catch (CmdLineException e) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            cmdLineParser.printUsage(stream);
            throw new CmdLineException(e.getMessage() + "\n" + stream.toString());
        }
        if (strings.length == 0 || flags.getDisplayHelp()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            cmdLineParser.printUsage(stream);
            this.cmdLineFlags.printUsage(stream);
            throw new CmdLineException(stream.toString());
        }
        return flags;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongOptionHandler
    extends OptionHandler<Long> {
        public LongOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super Long> setter) {
            super(parser, option, setter);
        }

        @Override
        public String getDefaultMetaVariable() {
            return "VAR";
        }

        @Override
        public int parseArguments(Parameters params) throws CmdLineException {
            try {
                this.setter.addValue(Long.parseLong(params.getParameter(0)));
                return 1;
            }
            catch (NumberFormatException e) {
                throw new CmdLineException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringListOptionHandler
    extends OptionHandler<List<String>> {
        public StringListOptionHandler(CmdLineParser parser, OptionDef option, Setter<? super List<String>> setter) {
            super(parser, option, setter);
        }

        @Override
        public String getDefaultMetaVariable() {
            return "VAR";
        }

        @Override
        public int parseArguments(Parameters params) throws CmdLineException {
            String[] rawArgs = params.getParameter(0).split(",");
            ArrayList<String> args = new ArrayList<String>(rawArgs.length);
            for (String arg : rawArgs) {
                args.add(arg.trim());
            }
            this.setter.addValue(args);
            return 1;
        }
    }
}

